/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedMultiFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.monitoring.Monitors;

public class PhysicalLogicalTransactionStore
implements LogicalTransactionStore {
    private final LogFile logFile;
    private final TransactionMetadataCache transactionMetadataCache;
    private final LogEntryReader logEntryReader;
    private final Monitors monitors;
    private final boolean failOnCorruptedLogFiles;
    private final LogFiles logFiles;

    public PhysicalLogicalTransactionStore(LogFiles logFiles, TransactionMetadataCache transactionMetadataCache, LogEntryReader logEntryReader, Monitors monitors, boolean failOnCorruptedLogFiles) {
        this.logFiles = logFiles;
        this.logFile = logFiles.getLogFile();
        this.transactionMetadataCache = transactionMetadataCache;
        this.logEntryReader = logEntryReader;
        this.monitors = monitors;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)this.logFile.getReader(position), this.logEntryReader);
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition backToPosition) {
        return ReversedMultiFileTransactionCursor.fromLogFile(this.logFiles, this.logFile, backToPosition, this.logEntryReader, this.failOnCorruptedLogFiles, (ReversedTransactionCursorMonitor)this.monitors.newMonitor(ReversedTransactionCursorMonitor.class, new String[0]));
    }

    @Override
    public TransactionCursor getTransactions(long transactionIdToStartFrom) throws IOException {
        try {
            TransactionMetadataCache.TransactionMetadata transactionMetadata = this.transactionMetadataCache.getTransactionMetadata(transactionIdToStartFrom);
            if (transactionMetadata != null) {
                ReadableLogChannel channel = this.logFile.getReader(transactionMetadata.getStartPosition());
                return new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)channel, this.logEntryReader);
            }
            LogVersionLocator headerVisitor = new LogVersionLocator(transactionIdToStartFrom);
            this.logFiles.accept(headerVisitor);
            TransactionPositionLocator transactionPositionLocator = new TransactionPositionLocator(transactionIdToStartFrom, this.logEntryReader);
            this.logFile.accept(transactionPositionLocator, headerVisitor.getLogPosition());
            LogPosition position = transactionPositionLocator.getAndCacheFoundLogPosition(this.transactionMetadataCache);
            return new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)this.logFile.getReader(position), this.logEntryReader);
        }
        catch (FileNotFoundException e) {
            throw new NoSuchTransactionException(transactionIdToStartFrom, "Log position acquired, but couldn't find the log file itself. Perhaps it just recently was deleted? [" + e.getMessage() + "]", e);
        }
    }

    public static final class LogVersionLocator
    implements LogHeaderVisitor {
        private final long transactionId;
        private LogPosition foundPosition;

        public LogVersionLocator(long transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public boolean visit(LogHeader logHeader, LogPosition position, long firstTransactionIdInLog, long lastTransactionIdInLog) {
            boolean foundIt;
            boolean bl = foundIt = this.transactionId >= firstTransactionIdInLog && this.transactionId <= lastTransactionIdInLog;
            if (foundIt) {
                this.foundPosition = position;
            }
            return !foundIt;
        }

        public LogPosition getLogPosition() throws NoSuchTransactionException {
            if (this.foundPosition == null) {
                throw new NoSuchTransactionException(this.transactionId, "Couldn't find any log containing " + this.transactionId);
            }
            return this.foundPosition;
        }
    }

    public static class TransactionPositionLocator
    implements LogFile.LogFileVisitor {
        private final long startTransactionId;
        private final LogEntryReader logEntryReader;
        private LogEntryStart startEntryForFoundTransaction;
        private long commitTimestamp;
        private int commitChecksum;

        TransactionPositionLocator(long startTransactionId, LogEntryReader logEntryReader) {
            this.startTransactionId = startTransactionId;
            this.logEntryReader = logEntryReader;
        }

        @Override
        public boolean visit(ReadableClosablePositionAwareChecksumChannel channel) throws IOException {
            LogEntry logEntry;
            LogEntryStart startEntry = null;
            while ((logEntry = this.logEntryReader.readLogEntry(channel)) != null) {
                switch (logEntry.getType()) {
                    case 1: {
                        startEntry = (LogEntryStart)logEntry;
                        break;
                    }
                    case 5: {
                        LogEntryCommit commit = (LogEntryCommit)logEntry;
                        if (commit.getTxId() != this.startTransactionId) break;
                        this.startEntryForFoundTransaction = startEntry;
                        this.commitTimestamp = commit.getTimeWritten();
                        this.commitChecksum = commit.getChecksum();
                        return false;
                    }
                }
            }
            return true;
        }

        LogPosition getAndCacheFoundLogPosition(TransactionMetadataCache transactionMetadataCache) throws NoSuchTransactionException {
            if (this.startEntryForFoundTransaction == null) {
                throw new NoSuchTransactionException(this.startTransactionId);
            }
            transactionMetadataCache.cacheTransactionMetadata(this.startTransactionId, this.startEntryForFoundTransaction.getStartPosition(), this.commitChecksum, this.commitTimestamp);
            return this.startEntryForFoundTransaction.getStartPosition();
        }
    }
}

