/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DefaultIndexProviderMap
extends LifecycleAdapter
implements IndexProviderMap {
    private final Map<IndexProviderDescriptor, IndexProvider> indexProvidersByDescriptor = new HashMap<IndexProviderDescriptor, IndexProvider>();
    private final Map<String, IndexProvider> indexProvidersByName = new HashMap<String, IndexProvider>();
    private final DependencyResolver dependencies;
    private IndexProvider defaultIndexProvider;
    private IndexProvider fulltextIndexProvider;
    private final Config config;

    public DefaultIndexProviderMap(DependencyResolver dependencies, Config config) {
        this.dependencies = dependencies;
        this.config = config;
    }

    public void init() {
        Iterable indexProviders = this.dependencies.resolveTypeDependencies(IndexProvider.class);
        for (IndexProvider provider : indexProviders) {
            IndexProviderDescriptor providerDescriptor = provider.getProviderDescriptor();
            Objects.requireNonNull(providerDescriptor);
            IndexProvider existing = this.put(providerDescriptor, provider);
            if (existing == null) continue;
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + providerDescriptor + ". First loaded " + existing + " then " + provider);
        }
        this.initDefaultProviders();
    }

    @Override
    public IndexProvider getDefaultProvider() {
        this.assertInit();
        return this.defaultIndexProvider;
    }

    @Override
    public IndexProvider getFulltextProvider() {
        this.assertInit();
        return this.fulltextIndexProvider;
    }

    @Override
    public IndexProvider lookup(IndexProviderDescriptor providerDescriptor) {
        this.assertInit();
        IndexProvider provider = this.indexProvidersByDescriptor.get(providerDescriptor);
        this.assertProviderFound(provider, providerDescriptor.name());
        return provider;
    }

    @Override
    public IndexProvider lookup(String providerDescriptorName) throws IndexProviderNotFoundException {
        this.assertInit();
        IndexProvider provider = this.indexProvidersByName.get(providerDescriptorName);
        this.assertProviderFound(provider, providerDescriptorName);
        return provider;
    }

    @Override
    public void accept(Consumer<IndexProvider> visitor) {
        this.assertInit();
        this.indexProvidersByDescriptor.values().forEach(visitor);
    }

    private void assertProviderFound(IndexProvider provider, String providerDescriptorName) {
        if (provider == null) {
            throw new IndexProviderNotFoundException("Tried to get index provider with name " + providerDescriptorName + " whereas available providers in this session being " + this.indexProvidersByName.keySet() + ", and default being " + this.defaultIndexProvider.getProviderDescriptor().name());
        }
    }

    private void assertInit() {
        if (this.defaultIndexProvider == null || this.fulltextIndexProvider == null) {
            throw new IllegalStateException("DefaultIndexProviderMap must be part of life cycle and initialized before getting providers.");
        }
    }

    private void initDefaultProviders() {
        String providerName = (String)this.config.get(GraphDatabaseSettings.default_schema_provider);
        IndexProvider configuredDefaultProvider = this.indexProvidersByName.get(providerName);
        Objects.requireNonNull(configuredDefaultProvider, () -> String.format("Configured default provider: `%s` not found. Available index providers: %s.", providerName, this.indexProvidersByName.keySet().toString()));
        this.defaultIndexProvider = configuredDefaultProvider;
        String fulltextProviderName = (String)this.config.get(GraphDatabaseSettings.default_fulltext_provider);
        this.fulltextIndexProvider = this.indexProvidersByName.get(fulltextProviderName);
        if (this.fulltextIndexProvider == null) {
            this.fulltextIndexProvider = IndexProvider.EMPTY;
        }
    }

    private IndexProvider put(IndexProviderDescriptor providerDescriptor, IndexProvider provider) {
        IndexProvider existing = this.indexProvidersByDescriptor.putIfAbsent(providerDescriptor, provider);
        this.indexProvidersByName.putIfAbsent(providerDescriptor.name(), provider);
        return existing;
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        IndexProviderDescriptor providerDescriptor = index.getIndexProvider();
        IndexProvider provider = this.lookup(providerDescriptor);
        return provider.completeConfiguration(index);
    }
}

