/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.neo4j.internal.helpers.collection.NumberAwareStringComparator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.util.Preconditions;

public class Converters {
    private static final Comparator<File> BY_FILE_NAME = Comparator.comparing(File::getName);
    private static final Comparator<File> BY_FILE_NAME_WITH_CLEVER_NUMBERS = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.getAbsolutePath(), o2.getAbsolutePath());

    private Converters() {
    }

    public static <T> Function<String, T> optional() {
        return from -> null;
    }

    public static Function<String, File[]> regexFiles(boolean cleverNumberRegexSort) {
        return name -> {
            Comparator<File> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
            List<File> files = Validators.matchingFiles(name.trim());
            files.sort(sorting);
            return files.toArray(new File[0]);
        };
    }

    public static Function<String, File[]> toFiles(String delimiter, Function<String, File[]> eachFileConverter) {
        return from -> {
            if (from == null) {
                return new File[0];
            }
            String[] names = Converters.quotationAwareSplit(from, delimiter);
            ArrayList<File> files = new ArrayList<File>();
            for (String name : names) {
                files.addAll(Arrays.asList((File[])eachFileConverter.apply(name)));
            }
            return files.toArray(new File[0]);
        };
    }

    private static String[] quotationAwareSplit(String from, String delimiter) {
        String[] parts = from.split(delimiter);
        ArrayList<String> mendedParts = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            Object part = parts[i];
            if (((String)part).startsWith("'")) {
                while (!((String)part).endsWith("'")) {
                    Preconditions.checkState((i + 1 < parts.length ? 1 : 0) != 0, (String)"When splitting \"%s\" the inner start quote in part \"%s\" had no matching end quote", (Object[])new Object[]{from, part});
                    part = (String)part + delimiter + parts[++i];
                }
                part = ((String)part).substring(1, ((String)part).length() - 1);
            }
            mendedParts.add((String)part);
        }
        return mendedParts.toArray(new String[0]);
    }
}

