/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.set.MutableSet;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.kernel.impl.util.collection.LongProbeTable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class DistinctSet<T extends Measurable>
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DistinctSet.class);
    private final MemoryTracker scopedMemoryTracker;
    private final MutableSet<T> distinctSet;

    public static <T extends Measurable> DistinctSet<T> createDistinctSet(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + LongProbeTable.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new DistinctSet<T>(scopedMemoryTracker);
    }

    private DistinctSet(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.distinctSet = HeapTrackingCollections.newSet((MemoryTracker)scopedMemoryTracker);
    }

    public boolean add(T element) {
        boolean wasAdded = this.distinctSet.add(element);
        if (wasAdded) {
            this.scopedMemoryTracker.allocateHeap(element.estimatedHeapUsage());
        }
        return wasAdded;
    }

    public void each(Procedure<? super T> procedure) {
        this.distinctSet.each(procedure);
    }

    @Override
    public void close() {
        this.scopedMemoryTracker.close();
    }
}

