/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class RecoveryFacade {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final DatabaseTracers tracers;
    private final Config config;
    private final StorageEngineFactory storageEngineFactory;
    private final MemoryTracker memoryTracker;

    RecoveryFacade(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, StorageEngineFactory storageEngineFactory, MemoryTracker memoryTracker) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.tracers = tracers;
        this.config = config;
        this.storageEngineFactory = storageEngineFactory;
        this.memoryTracker = memoryTracker;
    }

    public void recovery(DatabaseLayout databaseLayout) throws IOException {
        Recovery.performRecovery(this.fs, this.pageCache, this.tracers, this.config, databaseLayout, this.storageEngineFactory, this.memoryTracker);
    }
}

