/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;

public abstract class AbstractSystemGraphComponent
implements SystemGraphComponent {
    protected final Config config;

    public AbstractSystemGraphComponent(Config config) {
        this.config = config;
    }

    protected void initializeSystemGraphConstraints(Transaction tx) {
    }

    protected void initializeSystemGraphModel(Transaction tx) throws Exception {
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
    }

    private void initializeSystemGraphConstraints(GraphDatabaseService system) {
        try (Transaction tx = system.beginTx();){
            this.initializeSystemGraphConstraints(tx);
            tx.commit();
        }
    }

    protected void initializeSystemGraphModel(GraphDatabaseService system) throws Exception {
        try (Transaction tx = system.beginTx();){
            this.initializeSystemGraphModel(tx);
            tx.commit();
        }
    }

    protected void postInitialization(GraphDatabaseService system, boolean wasInitialized) throws Exception {
    }

    @Override
    public Optional<Exception> initializeSystemGraph(GraphDatabaseService system) {
        boolean mayUpgrade = (Boolean)this.config.get(GraphDatabaseSettings.allow_single_automatic_upgrade);
        assert (system.databaseName().equals("system"));
        try {
            SystemGraphComponent.Status status = this.detect(system);
            if (status == SystemGraphComponent.Status.UNINITIALIZED) {
                try {
                    this.initializeSystemGraphConstraints(system);
                }
                catch (Exception e) {
                    return Optional.of(e);
                }
                try {
                    this.initializeSystemGraphModel(system);
                }
                catch (Exception e) {
                    return Optional.of(e);
                }
                try {
                    this.postInitialization(system, true);
                }
                catch (Exception e) {
                    return Optional.of(e);
                }
            }
            if (status == SystemGraphComponent.Status.CURRENT || status == SystemGraphComponent.Status.REQUIRES_UPGRADE && !mayUpgrade) {
                try {
                    this.verifySystemGraph(system);
                    this.postInitialization(system, false);
                }
                catch (Exception e) {
                    return Optional.of(e);
                }
            } else {
                if (mayUpgrade && status == SystemGraphComponent.Status.REQUIRES_UPGRADE || status == SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE) {
                    return this.upgradeToCurrent(system);
                }
                return Optional.of(new IllegalStateException(String.format("Unsupported component state for '%s': %s", this.component(), status.description())));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    private SystemGraphComponent.Status detect(GraphDatabaseService system) {
        try (Transaction tx = system.beginTx();){
            SystemGraphComponent.Status status = this.detect(tx);
            tx.commit();
            SystemGraphComponent.Status status2 = status;
            return status2;
        }
    }

    protected void initializeSystemGraphConstraint(Transaction tx, Label label, String property) {
        block2: {
            try {
                tx.schema().constraintFor(label).assertPropertyIsUnique(property).create();
            }
            catch (ConstraintViolationException e) {
                if (e.getMessage().startsWith("An equivalent constraint already exists")) break block2;
                throw e;
            }
        }
    }
}

