/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

public class NativeAllEntriesReader<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements BoundedIterable<Long> {
    private final GBPTree<KEY, VALUE> tree;
    private final Layout<KEY, VALUE> layout;
    private final long fromIdInclusive;
    private final long toIdExclusive;
    private final PageCursorTracer cursorTracer;
    private Seeker<KEY, VALUE> seeker;

    NativeAllEntriesReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout, long fromIdInclusive, long toIdExclusive, PageCursorTracer cursorTracer) {
        this.tree = tree;
        this.layout = layout;
        this.fromIdInclusive = fromIdInclusive;
        this.toIdExclusive = toIdExclusive;
        this.cursorTracer = cursorTracer;
    }

    public Iterator<Long> iterator() {
        NativeIndexKey from = (NativeIndexKey)((Object)this.layout.newKey());
        from.initialize(Long.MIN_VALUE);
        from.initValuesAsLowest();
        NativeIndexKey to = (NativeIndexKey)((Object)this.layout.newKey());
        to.initialize(Long.MAX_VALUE);
        to.initValuesAsHighest();
        try {
            this.closeSeeker();
            this.seeker = this.tree.seek((Object)from, (Object)to, this.cursorTracer);
            return new PrefetchingIterator<Long>(){

                protected Long fetchNextOrNull() {
                    try {
                        long id;
                        do {
                            if (NativeAllEntriesReader.this.seeker.next()) continue;
                            return null;
                        } while ((id = ((NativeIndexKey)((Object)NativeAllEntriesReader.this.seeker.key())).getEntityId()) < NativeAllEntriesReader.this.fromIdInclusive || id >= NativeAllEntriesReader.this.toIdExclusive);
                        return id;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void closeSeeker() throws IOException {
        if (this.seeker != null) {
            this.seeker.close();
            this.seeker = null;
        }
    }

    public void close() throws Exception {
        this.closeSeeker();
    }

    public long maxCount() {
        return -1L;
    }
}

