/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;

class TransactionLogFilesContext {
    private final AtomicLong rotationThreshold;
    private final AtomicBoolean tryPreallocateTransactionLogs;
    private final LogEntryReader logEntryReader;
    private final LongSupplier lastCommittedTransactionIdSupplier;
    private final LongSupplier committingTransactionIdSupplier;
    private final Supplier<LogPosition> lastClosedPositionSupplier;
    private final Supplier<LogVersionRepository> logVersionRepositorySupplier;
    private final FileSystemAbstraction fileSystem;
    private final LogProvider logProvider;
    private final DatabaseTracers databaseTracers;
    private final Supplier<StoreId> storeId;
    private final NativeAccess nativeAccess;
    private final MemoryTracker memoryTracker;

    TransactionLogFilesContext(AtomicLong rotationThreshold, AtomicBoolean tryPreallocateTransactionLogs, LogEntryReader logEntryReader, LongSupplier lastCommittedTransactionIdSupplier, LongSupplier committingTransactionIdSupplier, Supplier<LogPosition> lastClosedPositionSupplier, Supplier<LogVersionRepository> logVersionRepositorySupplier, FileSystemAbstraction fileSystem, LogProvider logProvider, DatabaseTracers databaseTracers, Supplier<StoreId> storeId, NativeAccess nativeAccess, MemoryTracker memoryTracker) {
        this.rotationThreshold = rotationThreshold;
        this.tryPreallocateTransactionLogs = tryPreallocateTransactionLogs;
        this.logEntryReader = logEntryReader;
        this.lastCommittedTransactionIdSupplier = lastCommittedTransactionIdSupplier;
        this.committingTransactionIdSupplier = committingTransactionIdSupplier;
        this.lastClosedPositionSupplier = lastClosedPositionSupplier;
        this.logVersionRepositorySupplier = logVersionRepositorySupplier;
        this.fileSystem = fileSystem;
        this.logProvider = logProvider;
        this.databaseTracers = databaseTracers;
        this.storeId = storeId;
        this.nativeAccess = nativeAccess;
        this.memoryTracker = memoryTracker;
    }

    AtomicLong getRotationThreshold() {
        return this.rotationThreshold;
    }

    LogEntryReader getLogEntryReader() {
        return this.logEntryReader;
    }

    LogVersionRepository getLogVersionRepository() {
        return this.logVersionRepositorySupplier.get();
    }

    long getLastCommittedTransactionId() {
        return this.lastCommittedTransactionIdSupplier.getAsLong();
    }

    long committingTransactionId() {
        return this.committingTransactionIdSupplier.getAsLong();
    }

    LogPosition getLastClosedTransactionPosition() {
        return this.lastClosedPositionSupplier.get();
    }

    FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    public LogProvider getLogProvider() {
        return this.logProvider;
    }

    AtomicBoolean getTryPreallocateTransactionLogs() {
        return this.tryPreallocateTransactionLogs;
    }

    NativeAccess getNativeAccess() {
        return this.nativeAccess;
    }

    DatabaseTracers getDatabaseTracers() {
        return this.databaseTracers;
    }

    public StoreId getStoreId() {
        return this.storeId.get();
    }

    public MemoryTracker getMemoryTracker() {
        return this.memoryTracker;
    }
}

