/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import javax.annotation.Nullable;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;

public class NodeStoreScan<FAILURE extends Exception>
extends PropertyAwareEntityStoreScan<StorageNodeCursor, FAILURE> {
    private final Visitor<EntityTokenUpdate, FAILURE> labelUpdateVisitor;
    private final Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor;
    protected final int[] labelIds;

    public NodeStoreScan(StorageReader storageReader, LockService locks, @Nullable Visitor<EntityTokenUpdate, FAILURE> labelUpdateVisitor, @Nullable Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        super(storageReader, NodeStoreScan.nodeCount(storageReader, cursorTracer), propertyKeyIdFilter, id -> locks.acquireNodeLock(id, LockService.LockType.READ_LOCK), cursorTracer, memoryTracker);
        this.labelUpdateVisitor = labelUpdateVisitor;
        this.propertyUpdatesVisitor = propertyUpdatesVisitor;
        this.labelIds = labelIds;
    }

    @Override
    protected StorageNodeCursor allocateCursor(StorageReader storageReader, PageCursorTracer cursorTracer) {
        return storageReader.allocateNodeCursor(cursorTracer);
    }

    @Override
    public boolean process(StorageNodeCursor cursor) throws FAILURE {
        EntityUpdates.Builder updates;
        long[] labels = cursor.labels();
        if (labels.length == 0 && this.labelIds.length != 0) {
            return false;
        }
        if (this.labelUpdateVisitor != null) {
            this.labelUpdateVisitor.visit((Object)EntityTokenUpdate.tokenChanges((long)cursor.entityReference(), (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])labels));
        }
        if (this.propertyUpdatesVisitor != null && NodeStoreScan.containsAnyEntityToken(this.labelIds, labels) && this.hasRelevantProperty(cursor, updates = EntityUpdates.forEntity((long)cursor.entityReference(), (boolean)true).withTokens(labels))) {
            return this.propertyUpdatesVisitor.visit((Object)updates.build());
        }
        return false;
    }

    private static long nodeCount(StorageReader reader, PageCursorTracer cursorTracer) {
        return reader.nodesGetCount(cursorTracer);
    }
}

