/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.locker.Locker;

class GlobalFileLocker
extends Locker {
    private static final Set<File> lockedFiles = ConcurrentHashMap.newKeySet();

    GlobalFileLocker(FileSystemAbstraction fileSystemAbstraction, File lockFile) {
        super(fileSystemAbstraction, lockFile);
    }

    @Override
    public void checkLock() {
        super.checkLock();
        lockedFiles.add(this.lockFile());
    }

    @Override
    protected boolean haveLockAlready() {
        if (lockedFiles.contains(this.lockFile())) {
            if (this.lockFileLock != null) {
                return true;
            }
            throw this.unableToObtainLockException();
        }
        return false;
    }

    @Override
    protected void releaseLock() throws IOException {
        lockedFiles.remove(this.lockFile());
        super.releaseLock();
    }
}

