/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Collection;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.NativeHitIterator;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.values.storable.Value;

class FilteringNativeHitIterator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeHitIterator<KEY, VALUE> {
    private final IndexQuery[] filters;

    FilteringNativeHitIterator(Seeker<KEY, VALUE> seeker, Collection<Seeker<KEY, VALUE>> toRemoveFromWhenExhausted, IndexQuery[] filters) {
        super(seeker, toRemoveFromWhenExhausted);
        this.filters = filters;
    }

    @Override
    boolean acceptValues(Value[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.filters[i].acceptsValue(values[i])) continue;
            return false;
        }
        return true;
    }
}

