/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;

public final class NativeIndexes {
    private NativeIndexes() {
    }

    public static InternalIndexState readState(PageCache pageCache, Path indexFile, PageCursorTracer cursorTracer) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        GBPTree.readHeader((PageCache)pageCache, (Path)indexFile, (Header.Reader)headerReader, (PageCursorTracer)cursorTracer);
        switch (headerReader.state) {
            case 0: {
                return InternalIndexState.FAILED;
            }
            case 1: {
                return InternalIndexState.ONLINE;
            }
            case 2: {
                return InternalIndexState.POPULATING;
            }
        }
        throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
    }

    static String readFailureMessage(PageCache pageCache, Path indexFile, PageCursorTracer cursorTracer) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(GBPTree.NO_HEADER_READER);
        GBPTree.readHeader((PageCache)pageCache, (Path)indexFile, (Header.Reader)headerReader, (PageCursorTracer)cursorTracer);
        return headerReader.failureMessage;
    }
}

