/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialConfigVisitor;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.Value;

class GenericNativeIndexAccessor
extends NativeIndexAccessor<GenericKey, NativeIndexValue> {
    private final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private final TokenNameLookup tokenNameLookup;
    private IndexValueValidator validator;

    GenericNativeIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<GenericKey, NativeIndexValue> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings, SpaceFillingCurveConfiguration configuration, TokenNameLookup tokenNameLookup) {
        super(databaseIndexContext, indexFiles, layout, descriptor, GBPTree.NO_HEADER_WRITER);
        this.spaceFillingCurveSettings = spaceFillingCurveSettings;
        this.configuration = configuration;
        this.tokenNameLookup = tokenNameLookup;
        this.instantiateTree(recoveryCleanupWorkCollector, this.headerWriter);
    }

    @Override
    protected void afterTreeInstantiation(GBPTree<GenericKey, NativeIndexValue> tree) {
        this.validator = new GenericIndexKeyValidator(tree.keyValueSizeCap(), this.descriptor, (Layout<GenericKey, NativeIndexValue>)this.layout, this.tokenNameLookup);
    }

    @Override
    public IndexReader newReader() {
        this.assertOpen();
        return new GenericNativeIndexReader((GBPTree<GenericKey, NativeIndexValue>)this.tree, this.layout, this.descriptor, this.spaceFillingCurveSettings, this.configuration);
    }

    public void validateBeforeCommit(long entityId, Value[] tuple) {
        this.validator.validate(entityId, tuple);
    }

    @Override
    public void force(IOLimiter ioLimiter, PageCursorTracer cursorTracer) {
        this.tree.checkpoint(ioLimiter, (Consumer)this.headerWriter, cursorTracer);
    }

    public Map<String, Value> indexConfig() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        this.spaceFillingCurveSettings.visitIndexSpecificSettings(new SpatialConfigVisitor(map));
        return map;
    }

    public IndexEntriesReader[] newAllIndexEntriesReader(int partitions, PageCursorTracer cursorTracer) {
        GenericKey lowest = (GenericKey)((Object)this.layout.newKey());
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValuesAsLowest();
        GenericKey highest = (GenericKey)((Object)this.layout.newKey());
        highest.initialize(Long.MAX_VALUE);
        highest.initValuesAsHighest();
        try {
            Collection seekers = this.tree.partitionedSeek((Object)lowest, (Object)highest, partitions, cursorTracer);
            ArrayList<1> readers = new ArrayList<1>();
            for (final Seeker seeker : seekers) {
                readers.add(new IndexEntriesReader(){

                    public long next() {
                        return ((GenericKey)((Object)seeker.key())).getEntityId();
                    }

                    public boolean hasNext() {
                        try {
                            return seeker.next();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    public Value[] values() {
                        return ((GenericKey)((Object)seeker.key())).asValues();
                    }

                    public void close() {
                        try {
                            seeker.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                });
            }
            return (IndexEntriesReader[])readers.toArray(IndexEntriesReader[]::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

