/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.Log;

public class JvmChecker {
    private static final int SUPPORTED_FEATURE_VERSION = 11;
    static final String INCOMPATIBLE_JVM_WARNING = "You are using an unsupported Java runtime. Please use Oracle(R) Java(TM) 11, OpenJDK(TM) 11.";
    static final String INCOMPATIBLE_JVM_VERSION_WARNING = "You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) 11 or OpenJDK(TM) 11.";
    private static final Pattern SUPPORTED_JAVA_NAME_PATTERN = Pattern.compile("(Java HotSpot\\(TM\\)|OpenJDK) (64-Bit Server|Server) VM");
    private static final String NO_SERIALIZATION_FILTER_WARNING = "The version of the Java runtime you are using  does not include some important security features. Please use a JRE of version 8u121 or higher.";
    private final Log log;
    private final JvmMetadataRepository jvmMetadataRepository;

    public JvmChecker(Log log, JvmMetadataRepository jvmMetadataRepository) {
        this.log = log;
        this.jvmMetadataRepository = jvmMetadataRepository;
    }

    public void checkJvmCompatibilityAndIssueWarning() {
        String javaVmName = this.jvmMetadataRepository.getJavaVmName();
        Runtime.Version javaVersion = this.jvmMetadataRepository.getJavaVersion();
        if (!SUPPORTED_JAVA_NAME_PATTERN.matcher(javaVmName).matches()) {
            this.log.warn(INCOMPATIBLE_JVM_WARNING);
        } else if (javaVersion.feature() != 11) {
            this.log.warn(INCOMPATIBLE_JVM_VERSION_WARNING);
        }
        List<String> jvmArguments = this.jvmMetadataRepository.getJvmInputArguments();
        MemoryUsage heapMemoryUsage = this.jvmMetadataRepository.getHeapMemoryUsage();
        if (JvmChecker.missingOption(jvmArguments, "-Xmx")) {
            this.log.warn(JvmChecker.maxMemorySettingWarning(heapMemoryUsage.getMax()));
        }
        if (JvmChecker.missingOption(jvmArguments, "-Xms")) {
            this.log.warn(JvmChecker.initialMemorySettingWarning(heapMemoryUsage.getInit()));
        }
        if (!this.serializationFilterIsAvailable()) {
            this.log.warn(NO_SERIALIZATION_FILTER_WARNING);
        }
    }

    static String initialMemorySettingWarning(long currentUsage) {
        return String.format("The initial heap memory has not been configured. It is recommended that it is always explicitly configured, to ensure the system has a balanced configuration. Until then, a JVM computed heuristic of %d bytes is used instead. If you are running neo4j server, you need to configure %s in neo4j.conf. If you are running neo4j embedded, you have to launch the JVM with -Xms set to a value. You can run neo4j-admin memrec for memory configuration suggestions.", currentUsage, ExternalSettings.initial_heap_size.name());
    }

    static String maxMemorySettingWarning(long currentUsage) {
        return String.format("The max heap memory has not been configured. It is recommended that it is always explicitly configured, to ensure the system has a balanced configuration. Until then, a JVM computed heuristic of %d bytes is used instead. If you are running neo4j server, you need to configure %s in neo4j.conf. If you are running neo4j embedded, you have to launch the JVM with -Xmx set to a value. You can run neo4j-admin memrec for memory configuration suggestions.", currentUsage, ExternalSettings.max_heap_size.name());
    }

    private static boolean missingOption(List<String> jvmArguments, String option) {
        String normalizedOption = option.toUpperCase(Locale.ROOT);
        return jvmArguments.stream().noneMatch(o -> o.toUpperCase(Locale.ROOT).startsWith(normalizedOption));
    }

    boolean serializationFilterIsAvailable() {
        Stream<String> classNames = Stream.of("sun.misc.ObjectInputFilter", "java.io.ObjectInputFilter");
        return classNames.anyMatch(className -> {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        });
    }
}

