/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

public interface ComponentVersion {
    public static final String SECURITY_USER_COMPONENT = "security-users";
    public static final String SECURITY_PRIVILEGE_COMPONENT = "security-privileges";
    public static final String DBMS_RUNTIME_COMPONENT = "dbms-runtime";

    public int getVersion();

    public String getComponentName();

    public String getDescription();

    public boolean isCurrent();

    public boolean migrationSupported();

    public boolean runtimeSupported();

    default public boolean isGreaterThan(ComponentVersion other) {
        return this.getVersion() > other.getVersion();
    }

    public static class Neo4jVersions {
        public static final String VERSION_35 = "Neo4j 3.5";
        public static final String VERSION_36 = "Neo4j 3.6";
        public static final String VERSION_40 = "Neo4j 4.0";
        public static final String VERSION_41D1 = "Neo4j 4.1.0-Drop01";
        public static final String VERSION_41 = "Neo4j 4.1";
        public static final String VERSION_42D4 = "Neo4j 4.2.0-Drop04";
        public static final String VERSION_42D6 = "Neo4j 4.2.0-Drop06";
        public static final String VERSION_42D7 = "Neo4j 4.2.0-Drop07";
        public static final String VERSION_42 = "Neo4j 4.2.0";
        public static final String VERSION_42P1 = "Neo4j 4.2.1";
        public static final String VERSION_43D1 = "Neo4j 4.3.0-Drop01";
        public static final String VERSION_43D2 = "Neo4j 4.3.0-Drop02";
        public static final String VERSION_43D3 = "Neo4j 4.3.0-Drop03";
        public static final String VERSION_43D4 = "Neo4j 4.3.0-Drop04";
    }
}

