/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.util.VisibleForTesting;

public abstract class DbmsRuntimeRepository {
    private final DatabaseManager<?> databaseManager;
    final DbmsRuntimeSystemGraphComponent component;
    private volatile DbmsRuntimeVersion currentVersion;

    protected DbmsRuntimeRepository(DatabaseManager<?> databaseManager, DbmsRuntimeSystemGraphComponent component) {
        this.databaseManager = databaseManager;
        this.component = component;
    }

    protected void fetchStateFromSystemDatabase() {
        GraphDatabaseService systemDatabase = this.getSystemDb();
        this.currentVersion = (DbmsRuntimeVersion)this.component.fetchStateFromSystemDatabase(systemDatabase);
    }

    protected GraphDatabaseService getSystemDb() {
        return ((DatabaseContext)this.databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new RuntimeException("Failed to get System Database"))).databaseFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbmsRuntimeVersion getVersion() {
        if (this.currentVersion == null) {
            DbmsRuntimeRepository dbmsRuntimeRepository = this;
            synchronized (dbmsRuntimeRepository) {
                if (this.currentVersion == null) {
                    this.fetchStateFromSystemDatabase();
                }
            }
        }
        return this.currentVersion;
    }

    @VisibleForTesting
    public void setVersion(DbmsRuntimeVersion newVersion) {
        this.currentVersion = newVersion;
    }
}

