/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.eclipse.collections.api.factory.Sets;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexMonitorAdaptor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.monitoring.Monitors;

abstract class NativeIndex<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements ConsistencyCheckable {
    final PageCache pageCache;
    final IndexFiles indexFiles;
    final IndexLayout<KEY, VALUE> layout;
    final FileSystemAbstraction fileSystem;
    final IndexDescriptor descriptor;
    private final Monitors monitors;
    private final String monitorTag;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final PageCacheTracer pageCacheTracer;
    private final String databaseName;
    protected GBPTree<KEY, VALUE> tree;

    NativeIndex(DatabaseIndexContext databaseIndexContext, IndexLayout<KEY, VALUE> layout, IndexFiles indexFiles, IndexDescriptor descriptor) {
        this.pageCache = databaseIndexContext.pageCache;
        this.fileSystem = databaseIndexContext.fileSystem;
        this.monitors = databaseIndexContext.monitors;
        this.monitorTag = databaseIndexContext.monitorTag;
        this.readOnlyChecker = databaseIndexContext.readOnlyChecker;
        this.pageCacheTracer = databaseIndexContext.pageCacheTracer;
        this.databaseName = databaseIndexContext.databaseName;
        this.indexFiles = indexFiles;
        this.layout = layout;
        this.descriptor = descriptor;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) {
        this.ensureDirectoryExist();
        GBPTree.Monitor monitor = this.treeMonitor();
        Path storeFile = this.indexFiles.getStoreFile();
        this.tree = new GBPTree(this.pageCache, storeFile, this.layout, monitor, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector, this.readOnlyChecker, this.pageCacheTracer, Sets.immutable.empty(), this.databaseName, this.descriptor.getName());
        this.afterTreeInstantiation(this.tree);
    }

    protected void afterTreeInstantiation(GBPTree<KEY, VALUE> tree) {
    }

    private GBPTree.Monitor treeMonitor() {
        GBPTree.Monitor treeMonitor = (GBPTree.Monitor)this.monitors.newMonitor(GBPTree.Monitor.class, new String[]{this.monitorTag});
        IndexProvider.Monitor indexMonitor = (IndexProvider.Monitor)this.monitors.newMonitor(IndexProvider.Monitor.class, new String[]{this.monitorTag});
        return new IndexMonitorAdaptor(treeMonitor, indexMonitor, this.indexFiles, this.descriptor);
    }

    private void ensureDirectoryExist() {
        this.indexFiles.ensureDirectoryExist();
    }

    void closeTree() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
        this.tree = null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class), cursorContext);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<KEY> visitor, CursorContext cursorContext) {
        try {
            return this.tree.consistencyCheck(visitor, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

