/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.exceptions.FrozenLocksException;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.AcquireLockTimeoutException;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.MemoryTracker;

public class FrozenLockClient
implements Locks.Client {
    private final Locks.Client delegate;
    private int nesting;

    public FrozenLockClient(Locks.Client delegate) {
        this.delegate = delegate;
        this.nesting = 1;
    }

    public Locks.Client getRealLockClient() {
        return this.delegate;
    }

    public void freeze() {
        ++this.nesting;
    }

    public boolean thaw() {
        --this.nesting;
        return this.nesting == 0;
    }

    @Override
    public void initialize(LeaseClient leaseClient, long transactionId, MemoryTracker memoryTracker, Config config) {
        this.delegate.initialize(leaseClient, transactionId, memoryTracker, config);
    }

    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        throw this.frozenLockException();
    }

    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        throw this.frozenLockException();
    }

    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        throw this.frozenLockException();
    }

    @Override
    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        throw this.frozenLockException();
    }

    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        throw this.frozenLockException();
    }

    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        throw this.frozenLockException();
    }

    @Override
    public void prepareForCommit() {
        throw this.frozenLockException();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public void close() {
        throw this.frozenLockException();
    }

    @Override
    public int getLockSessionId() {
        return this.delegate.getLockSessionId();
    }

    public Stream<ActiveLock> activeLocks() {
        return this.delegate.activeLocks();
    }

    public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
        return this.delegate.holdsLock(id, resource, lockType);
    }

    @Override
    public long activeLockCount() {
        return this.delegate.activeLockCount();
    }

    private FrozenLocksException frozenLockException() {
        return new FrozenLocksException(this.delegate.getLockSessionId());
    }
}

