/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.eclipse.collections.api.factory.Sets;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsKey;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsLayout;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsValue;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsVisitor;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class IndexStatisticsStore
extends LifecycleAdapter
implements IndexStatisticsVisitor.Visitable,
ConsistencyCheckable {
    private static final ImmutableIndexStatistics EMPTY_STATISTICS = new ImmutableIndexStatistics(0L, 0L, 0L, 0L);
    private static final IndexStatisticsKey LOWEST_KEY = new IndexStatisticsKey(Long.MIN_VALUE);
    private static final IndexStatisticsKey HIGHEST_KEY = new IndexStatisticsKey(Long.MAX_VALUE);
    private static final String INIT_TAG = "Initialize IndexStatisticsStore";
    private final PageCache pageCache;
    private final Path path;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final String databaseName;
    private final PageCacheTracer pageCacheTracer;
    private final IndexStatisticsLayout layout;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private GBPTree<IndexStatisticsKey, IndexStatisticsValue> tree;
    private final ConcurrentHashMap<Long, ImmutableIndexStatistics> cache = new ConcurrentHashMap();

    public IndexStatisticsStore(PageCache pageCache, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseReadOnlyChecker readOnlyChecker, String databaseName, PageCacheTracer pageCacheTracer) {
        this.pageCache = pageCache;
        this.path = path;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.databaseName = databaseName;
        this.pageCacheTracer = pageCacheTracer;
        this.layout = new IndexStatisticsLayout();
        this.readOnlyChecker = readOnlyChecker;
    }

    public IndexStatisticsStore(PageCache pageCache, DatabaseLayout databaseLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseReadOnlyChecker readOnlyChecker, PageCacheTracer pageCacheTracer) {
        this(pageCache, databaseLayout.indexStatisticsStore(), recoveryCleanupWorkCollector, readOnlyChecker, databaseLayout.getDatabaseName(), pageCacheTracer);
    }

    public void init() throws IOException {
        try {
            this.tree = new GBPTree(this.pageCache, this.path, (Layout)this.layout, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, this.recoveryCleanupWorkCollector, this.readOnlyChecker, this.pageCacheTracer, Sets.immutable.empty(), this.databaseName, "Statistics store");
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Index statistics store file could not be found, most likely this database needs to be recovered, file:" + this.path, e);
        }
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(INIT_TAG));){
            this.scanTree((key, value) -> this.cache.put(key.getIndexId(), new ImmutableIndexStatistics((IndexStatisticsValue)value)), cursorContext);
        }
    }

    public IndexSample indexSample(long indexId) {
        ImmutableIndexStatistics value = this.cache.getOrDefault(indexId, EMPTY_STATISTICS);
        return new IndexSample(value.indexSize, value.sampleUniqueValues, value.sampleSize, value.updatesCount);
    }

    public void replaceStats(long indexId, IndexSample sample) {
        this.cache.put(indexId, new ImmutableIndexStatistics(sample.uniqueValues(), sample.sampleSize(), sample.updates(), sample.indexSize()));
    }

    public void removeIndex(long indexId) {
        this.cache.remove(indexId);
    }

    public void incrementIndexUpdates(long indexId, long delta) {
        this.cache.computeIfPresent(indexId, (id, existing) -> new ImmutableIndexStatistics(existing.sampleUniqueValues, existing.sampleSize, existing.updatesCount + delta, existing.indexSize));
    }

    @Override
    public void visit(IndexStatisticsVisitor visitor, CursorContext cursorContext) {
        try {
            this.scanTree((key, value) -> visitor.visitIndexStatistics(key.getIndexId(), value.getSampleUniqueValues(), value.getSampleSize(), value.getUpdatesCount(), value.getIndexSize()), cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void checkpoint(CursorContext cursorContext) throws IOException {
        this.clearTree(cursorContext);
        this.writeCacheContentsIntoTree(cursorContext);
        this.tree.checkpoint(cursorContext);
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<IndexStatisticsKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)), cursorContext);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<IndexStatisticsKey> visitor, CursorContext cursorContext) {
        try {
            return this.tree.consistencyCheck(visitor, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void scanTree(BiConsumer<IndexStatisticsKey, IndexStatisticsValue> consumer, CursorContext cursorContext) throws IOException {
        try (Seeker seek = this.tree.seek((Object)LOWEST_KEY, (Object)HIGHEST_KEY, cursorContext);){
            while (seek.next()) {
                IndexStatisticsKey key = this.layout.copyKey((IndexStatisticsKey)seek.key(), new IndexStatisticsKey());
                IndexStatisticsValue value = (IndexStatisticsValue)seek.value();
                consumer.accept(key, value);
            }
        }
    }

    private void clearTree(CursorContext cursorContext) throws IOException {
        ArrayList keys = new ArrayList(this.cache.size());
        this.scanTree((key, value) -> keys.add(key), cursorContext);
        try (Writer writer = this.tree.unsafeWriter(cursorContext);){
            for (IndexStatisticsKey key2 : keys) {
                writer.remove((Object)key2);
            }
        }
    }

    private void writeCacheContentsIntoTree(CursorContext cursorContext) throws IOException {
        try (Writer writer = this.tree.unsafeWriter(cursorContext);){
            for (Map.Entry<Long, ImmutableIndexStatistics> entry : this.cache.entrySet()) {
                ImmutableIndexStatistics stats = entry.getValue();
                writer.put((Object)new IndexStatisticsKey(entry.getKey()), (Object)new IndexStatisticsValue(stats.sampleUniqueValues, stats.sampleSize, stats.updatesCount, stats.indexSize));
            }
        }
    }

    public Path storeFile() {
        return this.path;
    }

    public void shutdown() throws IOException {
        if (this.tree != null) {
            this.tree.close();
        }
    }

    private static class ImmutableIndexStatistics {
        private final long sampleUniqueValues;
        private final long sampleSize;
        private final long updatesCount;
        private final long indexSize;

        ImmutableIndexStatistics(long sampleUniqueValues, long sampleSize, long updatesCount, long indexSize) {
            this.sampleUniqueValues = sampleUniqueValues;
            this.sampleSize = sampleSize;
            this.updatesCount = updatesCount;
            this.indexSize = indexSize;
        }

        ImmutableIndexStatistics(IndexStatisticsValue value) {
            this(value.getSampleUniqueValues(), value.getSampleSize(), value.getUpdatesCount(), value.getIndexSize());
        }
    }
}

