/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class LocalDateTimeArrayType
extends AbstractArrayType<LocalDateTime> {
    LocalDateTimeArrayType(byte typeId) {
        super(ValueGroup.LOCAL_DATE_TIME_ARRAY, typeId, (o1, o2, i) -> LocalDateTimeType.compare(o1.long0Array[i], o1.long1Array[i], o2.long0Array[i], o2.long1Array[i]), (k, i) -> LocalDateTimeType.asValueRaw(k.long0Array[i], k.long1Array[i]), (c, k, i) -> LocalDateTimeType.put(c, k.long0Array[i], k.long1Array[i]), LocalDateTimeType::read, LocalDateTime[]::new, ValueWriter.ArrayType.LOCAL_DATE_TIME);
    }

    @Override
    int valueSize(GenericKey state) {
        return LocalDateTimeArrayType.arrayKeySize(state, 12);
    }

    @Override
    void copyValue(GenericKey to, GenericKey from, int length) {
        this.initializeArray(to, length, null);
        System.arraycopy(from.long0Array, 0, to.long0Array, 0, length);
        System.arraycopy(from.long1Array, 0, to.long1Array, 0, length);
    }

    @Override
    void initializeArray(GenericKey key, int length, ValueWriter.ArrayType arrayType) {
        key.long0Array = LocalDateTimeArrayType.ensureBigEnough(key.long0Array, length);
        key.long1Array = LocalDateTimeArrayType.ensureBigEnough(key.long1Array, length);
    }

    static void write(GenericKey state, int offset, long epochSecond, int nano) {
        state.long0Array[offset] = nano;
        state.long1Array[offset] = epochSecond;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
        joiner.add("long1Array=" + Arrays.toString(state.long1Array));
        super.addTypeSpecificDetails(joiner, state);
    }
}

