/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.io.Serializable;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.forseti.LockingInternalSettings;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.WaitStrategy;
import org.neo4j.time.SystemNanoClock;

public class ForsetiLockManager
implements Locks {
    private final ConcurrentMap<Long, Lock>[] lockMaps;
    private final ResourceType[] resourceTypes;
    private final Pool<ForsetiClient> clientPool;
    private volatile boolean closed;

    public ForsetiLockManager(Config config, SystemNanoClock clock, ResourceType ... resourceTypes) {
        int maxResourceId = ForsetiLockManager.findMaxResourceId(resourceTypes);
        this.lockMaps = new ConcurrentMap[maxResourceId];
        this.resourceTypes = new ResourceType[maxResourceId];
        WaitStrategy[] waitStrategies = new WaitStrategy[maxResourceId];
        for (ResourceType type : resourceTypes) {
            this.lockMaps[type.typeId()] = new ConcurrentHashMap<Long, Lock>(16, 0.6f, 512);
            waitStrategies[type.typeId()] = type.waitStrategy();
            this.resourceTypes[type.typeId()] = type;
        }
        this.clientPool = new ForsetiClientFlyweightPool(config, clock, this.lockMaps, waitStrategies);
    }

    @Override
    public Locks.Client newClient() {
        if (this.closed) {
            throw new IllegalStateException(this + " already closed");
        }
        ForsetiClient forsetiClient = (ForsetiClient)this.clientPool.acquire();
        forsetiClient.reset();
        return forsetiClient;
    }

    @Override
    public void accept(Locks.Visitor out) {
        for (int i = 0; i < this.lockMaps.length; ++i) {
            if (this.lockMaps[i] == null) continue;
            ResourceType resourceType = this.resourceTypes[i];
            for (Map.Entry entry : this.lockMaps[i].entrySet()) {
                Lock lock = (Lock)entry.getValue();
                String description = lock.describeWaitList();
                LongSet transactionIds = lock.transactionIds();
                int lockIdentityHashCode = System.identityHashCode(lock);
                transactionIds.forEach((LongProcedure & Serializable)txId -> out.visit(lock.type(), resourceType, txId, (Long)entry.getKey(), description, 0L, lockIdentityHashCode));
            }
        }
    }

    private static int findMaxResourceId(ResourceType[] resourceTypes) {
        int max = 0;
        for (ResourceType resourceType : resourceTypes) {
            max = Math.max(resourceType.typeId(), max);
        }
        return max + 1;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private static class ForsetiClientFlyweightPool
    extends LinkedQueuePool<ForsetiClient> {
        private final AtomicInteger clientIds = new AtomicInteger(0);
        private final Queue<Integer> unusedIds = new ConcurrentLinkedQueue<Integer>();
        private final ConcurrentMap<Integer, ForsetiClient> clientsById = new ConcurrentHashMap<Integer, ForsetiClient>();
        private final Config config;
        private final SystemNanoClock clock;
        private final ConcurrentMap<Long, Lock>[] lockMaps;
        private final WaitStrategy[] waitStrategies;
        private final DeadlockResolutionStrategy deadlockResolutionStrategy;
        private final boolean verboseDeadlocks;

        ForsetiClientFlyweightPool(Config config, SystemNanoClock clock, ConcurrentMap<Long, Lock>[] lockMaps, WaitStrategy[] waitStrategies) {
            super(128, null);
            this.config = config;
            this.clock = clock;
            this.lockMaps = lockMaps;
            this.waitStrategies = waitStrategies;
            this.deadlockResolutionStrategy = (DeadlockResolutionStrategy)config.get(LockingInternalSettings.forseti_deadlock_resolution_strategy);
            this.verboseDeadlocks = (Boolean)config.get(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks);
        }

        protected ForsetiClient create() {
            Integer id = this.unusedIds.poll();
            if (id == null) {
                id = this.clientIds.getAndIncrement();
            }
            ForsetiClient client = new ForsetiClient(id, this.lockMaps, this.waitStrategies, (Pool<ForsetiClient>)this, this.deadlockResolutionStrategy, this.clientsById::get, this.clock, this.verboseDeadlocks);
            this.clientsById.put(id, client);
            return client;
        }

        protected void dispose(ForsetiClient resource) {
            super.dispose((Object)resource);
            this.clientsById.remove(resource.id());
            if (resource.id() < 1024) {
                this.unusedIds.offer(resource.id());
            }
        }
    }

    static interface DeadlockResolutionStrategy {
        public boolean shouldAbort(ForsetiClient var1, ForsetiClient var2);
    }

    static interface Lock {
        public void copyHolderWaitListsInto(SimpleBitSet var1);

        public int detectDeadlock(int var1);

        public String describeWaitList();

        public void collectOwners(Set<ForsetiClient> var1);

        public LockType type();

        public LongSet transactionIds();

        public boolean isClosed();
    }
}

