/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;

public class DefaultPooledCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;
    private DefaultNodeCursor nodeCursor;
    private FullAccessNodeCursor fullAccessNodeCursor;
    private DefaultRelationshipScanCursor relationshipScanCursor;
    private FullAccessRelationshipScanCursor fullAccessRelationshipScanCursor;
    private DefaultRelationshipTraversalCursor relationshipTraversalCursor;
    private FullAccessRelationshipTraversalCursor fullAccessRelationshipTraversalCursor;
    private DefaultPropertyCursor propertyCursor;
    private FullAccessPropertyCursor fullAccessPropertyCursor;
    private DefaultNodeValueIndexCursor nodeValueIndexCursor;
    private FullAccessNodeValueIndexCursor fullAccessNodeValueIndexCursor;
    private DefaultNodeLabelIndexCursor nodeLabelIndexCursor;
    private DefaultNodeLabelIndexCursor fullAccessNodeLabelIndexCursor;
    private DefaultRelationshipValueIndexCursor relationshipValueIndexCursor;
    private DefaultRelationshipTypeIndexCursor relationshipTypeIndexCursor;
    private DefaultRelationshipTypeIndexCursor fullAccessRelationshipTypeIndexCursor;

    public DefaultPooledCursors(StorageReader storageReader, Config config) {
        super(new ArrayList<DefaultCursors.CloseableStacktrace>(), config);
        this.storageReader = storageReader;
    }

    public DefaultNodeCursor allocateNodeCursor(CursorContext cursorContext) {
        if (this.nodeCursor == null) {
            return this.trace(new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext), this.storageReader.allocateNodeCursor(cursorContext)));
        }
        try {
            DefaultNodeCursor defaultNodeCursor = DefaultPooledCursors.acquire(this.nodeCursor);
            return defaultNodeCursor;
        }
        finally {
            this.nodeCursor = null;
        }
    }

    private void accept(DefaultNodeCursor cursor) {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        cursor.removeTracer();
        this.nodeCursor = cursor;
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor(CursorContext cursorContext) {
        if (this.fullAccessNodeCursor == null) {
            return this.trace(new FullAccessNodeCursor(this::acceptFullAccess, this.storageReader.allocateNodeCursor(cursorContext)));
        }
        try {
            FullAccessNodeCursor fullAccessNodeCursor = DefaultPooledCursors.acquire(this.fullAccessNodeCursor);
            return fullAccessNodeCursor;
        }
        finally {
            this.fullAccessNodeCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeCursor cursor) {
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessNodeCursor = (FullAccessNodeCursor)cursor;
    }

    public DefaultRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext) {
        if (this.relationshipScanCursor == null) {
            return this.trace(new DefaultRelationshipScanCursor(this::accept, this.storageReader.allocateRelationshipScanCursor(cursorContext), new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext), this.storageReader.allocateNodeCursor(cursorContext))));
        }
        try {
            DefaultRelationshipScanCursor defaultRelationshipScanCursor = DefaultPooledCursors.acquire(this.relationshipScanCursor);
            return defaultRelationshipScanCursor;
        }
        finally {
            this.relationshipScanCursor = null;
        }
    }

    private void accept(DefaultRelationshipScanCursor cursor) {
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.relationshipScanCursor = cursor;
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor(CursorContext cursorContext) {
        if (this.fullAccessRelationshipScanCursor == null) {
            return this.trace(new FullAccessRelationshipScanCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipScanCursor(cursorContext)));
        }
        try {
            RelationshipScanCursor relationshipScanCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipScanCursor);
            return relationshipScanCursor;
        }
        finally {
            this.fullAccessRelationshipScanCursor = null;
        }
    }

    private static <C extends TraceableCursor<?>> C acquire(C cursor) {
        cursor.acquire();
        return cursor;
    }

    private void acceptFullAccess(DefaultRelationshipScanCursor cursor) {
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipScanCursor = (FullAccessRelationshipScanCursor)cursor;
    }

    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext) {
        if (this.relationshipTraversalCursor == null) {
            return this.trace(new DefaultRelationshipTraversalCursor(this::accept, this.storageReader.allocateRelationshipTraversalCursor(cursorContext), new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext), this.storageReader.allocateNodeCursor(cursorContext))));
        }
        try {
            DefaultRelationshipTraversalCursor defaultRelationshipTraversalCursor = DefaultPooledCursors.acquire(this.relationshipTraversalCursor);
            return defaultRelationshipTraversalCursor;
        }
        finally {
            this.relationshipTraversalCursor = null;
        }
    }

    void accept(DefaultRelationshipTraversalCursor cursor) {
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTraversalCursor = cursor;
    }

    public RelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(CursorContext cursorContext) {
        if (this.fullAccessRelationshipTraversalCursor == null) {
            return this.trace(new FullAccessRelationshipTraversalCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipTraversalCursor(cursorContext)));
        }
        try {
            RelationshipTraversalCursor relationshipTraversalCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipTraversalCursor);
            return relationshipTraversalCursor;
        }
        finally {
            this.fullAccessRelationshipTraversalCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipTraversalCursor cursor) {
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipTraversalCursor = (FullAccessRelationshipTraversalCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultPropertyCursor allocatePropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.propertyCursor == null) {
            FullAccessNodeCursor nodeCursor = new FullAccessNodeCursor(this::acceptFullAccess, this.storageReader.allocateNodeCursor(cursorContext));
            FullAccessRelationshipScanCursor relCursor = new FullAccessRelationshipScanCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipScanCursor(cursorContext));
            return this.trace(new DefaultPropertyCursor(this::accept, this.storageReader.allocatePropertyCursor(cursorContext, memoryTracker), nodeCursor, relCursor));
        }
        try {
            DefaultPropertyCursor defaultPropertyCursor = DefaultPooledCursors.acquire(this.propertyCursor);
            return defaultPropertyCursor;
        }
        finally {
            this.propertyCursor = null;
        }
    }

    private void accept(DefaultPropertyCursor cursor) {
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        cursor.removeTracer();
        this.propertyCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullAccessPropertyCursor allocateFullAccessPropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessPropertyCursor == null) {
            return this.trace(new FullAccessPropertyCursor(this::acceptFullAccess, this.storageReader.allocatePropertyCursor(cursorContext, memoryTracker)));
        }
        try {
            FullAccessPropertyCursor fullAccessPropertyCursor = DefaultPooledCursors.acquire(this.fullAccessPropertyCursor);
            return fullAccessPropertyCursor;
        }
        finally {
            this.fullAccessPropertyCursor = null;
        }
    }

    private void acceptFullAccess(DefaultPropertyCursor cursor) {
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessPropertyCursor = (FullAccessPropertyCursor)cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeValueIndexCursor allocateNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.nodeValueIndexCursor == null) {
            return this.trace(new DefaultNodeValueIndexCursor(this::accept, new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext), this.storageReader.allocateNodeCursor(cursorContext)), memoryTracker));
        }
        try {
            DefaultNodeValueIndexCursor defaultNodeValueIndexCursor = DefaultPooledCursors.acquire(this.nodeValueIndexCursor);
            return defaultNodeValueIndexCursor;
        }
        finally {
            this.nodeValueIndexCursor = null;
        }
    }

    private void accept(DefaultNodeValueIndexCursor cursor) {
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeValueIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullAccessNodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessNodeValueIndexCursor == null) {
            return this.trace(new FullAccessNodeValueIndexCursor(this::acceptFullAccess, memoryTracker));
        }
        try {
            FullAccessNodeValueIndexCursor fullAccessNodeValueIndexCursor = DefaultPooledCursors.acquire(this.fullAccessNodeValueIndexCursor);
            return fullAccessNodeValueIndexCursor;
        }
        finally {
            this.fullAccessNodeValueIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeValueIndexCursor cursor) {
        if (this.fullAccessNodeValueIndexCursor != null) {
            this.fullAccessNodeValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessNodeValueIndexCursor = (FullAccessNodeValueIndexCursor)cursor;
    }

    public DefaultNodeLabelIndexCursor allocateNodeLabelIndexCursor(CursorContext cursorContext) {
        if (this.nodeLabelIndexCursor == null) {
            return this.trace(new DefaultNodeLabelIndexCursor(this::accept, new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext), this.storageReader.allocateNodeCursor(cursorContext))));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = DefaultPooledCursors.acquire(this.nodeLabelIndexCursor);
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.nodeLabelIndexCursor = null;
        }
    }

    private void accept(DefaultNodeLabelIndexCursor cursor) {
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeLabelIndexCursor = cursor;
    }

    public DefaultNodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(CursorContext cursorContext) {
        if (this.fullAccessNodeLabelIndexCursor == null) {
            return this.trace(new FullAccessNodeLabelIndexCursor(this::acceptFullAccess));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = DefaultPooledCursors.acquire(this.fullAccessNodeLabelIndexCursor);
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.fullAccessNodeLabelIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeLabelIndexCursor cursor) {
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
        }
        this.fullAccessNodeLabelIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipValueIndexCursor allocateRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipValueIndexCursor == null) {
            DefaultNodeCursor nodeCursor = new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext), this.storageReader.allocateNodeCursor(cursorContext));
            DefaultRelationshipScanCursor relationshipScanCursor = new DefaultRelationshipScanCursor(this::accept, this.storageReader.allocateRelationshipScanCursor(cursorContext), nodeCursor);
            return this.trace(new DefaultRelationshipValueIndexCursor(this::accept, relationshipScanCursor, memoryTracker));
        }
        try {
            RelationshipValueIndexCursor relationshipValueIndexCursor = DefaultPooledCursors.acquire(this.relationshipValueIndexCursor);
            return relationshipValueIndexCursor;
        }
        finally {
            this.relationshipValueIndexCursor = null;
        }
    }

    public void accept(DefaultRelationshipValueIndexCursor cursor) {
        if (this.relationshipValueIndexCursor != null) {
            this.relationshipValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipValueIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor(CursorContext cursorContext) {
        if (this.relationshipTypeIndexCursor == null) {
            DefaultNodeCursor nodeCursor = new DefaultNodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext), this.storageReader.allocateNodeCursor(cursorContext));
            DefaultRelationshipScanCursor relationshipScanCursor = new DefaultRelationshipScanCursor(this::accept, this.storageReader.allocateRelationshipScanCursor(cursorContext), nodeCursor);
            return this.trace(new DefaultRelationshipTypeIndexCursor(this::accept, relationshipScanCursor));
        }
        try {
            DefaultRelationshipTypeIndexCursor defaultRelationshipTypeIndexCursor = DefaultPooledCursors.acquire(this.relationshipTypeIndexCursor);
            return defaultRelationshipTypeIndexCursor;
        }
        finally {
            this.relationshipTypeIndexCursor = null;
        }
    }

    private void accept(DefaultRelationshipTypeIndexCursor cursor) {
        if (this.relationshipTypeIndexCursor != null) {
            this.relationshipTypeIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTypeIndexCursor = cursor;
    }

    public RelationshipTypeIndexCursor allocateFullAccessRelationshipTypeIndexCursor() {
        if (this.fullAccessRelationshipTypeIndexCursor == null) {
            return this.trace(new FullAccessRelationshipTypeIndexCursor(this::acceptFullAccess));
        }
        try {
            RelationshipTypeIndexCursor relationshipTypeIndexCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipTypeIndexCursor);
            return relationshipTypeIndexCursor;
        }
        finally {
            this.fullAccessRelationshipTypeIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipTypeIndexCursor cursor) {
        if (this.fullAccessRelationshipTypeIndexCursor != null) {
            this.fullAccessRelationshipTypeIndexCursor.release();
        }
        this.fullAccessRelationshipTypeIndexCursor = cursor;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        if (this.fullAccessPropertyCursor != null) {
            this.fullAccessPropertyCursor.release();
        }
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        if (this.fullAccessNodeValueIndexCursor != null) {
            this.fullAccessNodeValueIndexCursor.release();
        }
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
        }
        if (this.relationshipValueIndexCursor != null) {
            this.relationshipValueIndexCursor.release();
        }
        if (this.relationshipTypeIndexCursor != null) {
            this.relationshipTypeIndexCursor.release();
        }
        if (this.fullAccessRelationshipTypeIndexCursor != null) {
            this.fullAccessRelationshipTypeIndexCursor.release();
        }
        this.nodeCursor = null;
        this.fullAccessNodeCursor = null;
        this.relationshipScanCursor = null;
        this.fullAccessRelationshipScanCursor = null;
        this.relationshipTraversalCursor = null;
        this.fullAccessRelationshipTraversalCursor = null;
        this.propertyCursor = null;
        this.fullAccessPropertyCursor = null;
        this.nodeValueIndexCursor = null;
        this.fullAccessNodeValueIndexCursor = null;
        this.nodeLabelIndexCursor = null;
        this.fullAccessNodeLabelIndexCursor = null;
        this.relationshipValueIndexCursor = null;
        this.relationshipTypeIndexCursor = null;
        this.fullAccessRelationshipTypeIndexCursor = null;
    }
}

