/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StoreId;

public abstract class AbstractLogTailScanner {
    static final long NO_TRANSACTION_ID = -1L;
    protected final LogFiles logFiles;
    protected final LogEntryReader logEntryReader;
    protected final LogTailScannerMonitor monitor;
    protected final Log log;
    protected final MemoryTracker memoryTracker;
    private LogTailInformation logTailInformation;

    AbstractLogTailScanner(LogFiles logFiles, LogEntryReader logEntryReader, Monitors monitors, LogProvider log, MemoryTracker memoryTracker) {
        this.logFiles = logFiles;
        this.logEntryReader = logEntryReader;
        this.monitor = (LogTailScannerMonitor)monitors.newMonitor(LogTailScannerMonitor.class, new String[0]);
        this.log = log.getLog(this.getClass());
        this.memoryTracker = memoryTracker;
    }

    protected abstract LogTailInformation findLogTail() throws IOException;

    protected void verifyReaderPosition(long version, LogPosition logPosition) throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        long highestLogVersion = logFile.getHighestLogVersion();
        try (PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(version);){
            this.verifyLogVersion(version, logPosition);
            long logFileSize = channel.size();
            long channelLeftovers = Math.subtractExact(logFileSize, logPosition.getByteOffset());
            if (channelLeftovers != 0L) {
                AbstractLogTailScanner.verifyLastFile(highestLogVersion, version, logPosition, logFileSize, channelLeftovers);
                this.verifyNoMoreReadableDataAvailable(version, channel, logPosition, channelLeftovers);
            }
        }
    }

    private void verifyLogVersion(long version, LogPosition logPosition) {
        if (logPosition.getLogVersion() != version) {
            throw new IllegalStateException(String.format("Expected to observe log positions only for log file with version %d but encountered version %d while reading %s.", version, logPosition.getLogVersion(), FileUtils.getCanonicalFile((Path)this.logFiles.getLogFile().getLogFileForVersion(version))));
        }
    }

    static void throwUnableToCleanRecover(Throwable t) {
        throw new RuntimeException("Error reading transaction logs, recovery not possible. To force the database to start anyway, you can specify '" + GraphDatabaseInternalSettings.fail_on_corrupted_log_files.name() + "=false'. This will try to recover as much as possible and then truncate the corrupt part of the transaction log. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", t);
    }

    private static void verifyLastFile(long highestLogVersion, long version, LogPosition logPosition, long logFileSize, long channelLeftovers) {
        if (version != highestLogVersion) {
            throw new RuntimeException(String.format("Transaction log files with version %d has %d unreadable bytes. Was able to read upto %d but %d is available.", version, channelLeftovers, logPosition.getByteOffset(), logFileSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNoMoreReadableDataAvailable(long version, LogVersionedStoreChannel channel, LogPosition logPosition, long channelLeftovers) throws IOException {
        long initialPosition = channel.position();
        try {
            channel.position(logPosition.getByteOffset());
            try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(Numbers.safeCastLongToInt((long)Math.min(ByteUnit.kibiBytes((long)12L), channelLeftovers)), this.memoryTracker);){
                ByteBuffer byteBuffer = scopedBuffer.getBuffer();
                channel.readAll(byteBuffer);
                byteBuffer.flip();
                if (!AbstractLogTailScanner.isAllZerosBuffer(byteBuffer)) {
                    throw new RuntimeException(String.format("Transaction log files with version %d has some data available after last readable log entry. Last readable position %d, read ahead buffer content: %s.", version, logPosition.getByteOffset(), AbstractLogTailScanner.dumpBufferToString(byteBuffer)));
                }
            }
        }
        finally {
            channel.position(initialPosition);
        }
    }

    LogTailInformation checkpointTailInformation(long highestLogVersion, LogEntryStart latestStartEntry, long oldestVersionFound, byte latestLogEntryVersion, CheckpointInfo latestCheckPoint, boolean corruptedTransactionLogs, StoreId storeId) throws IOException {
        LogPosition checkPointLogPosition = latestCheckPoint.getTransactionLogPosition();
        ExtractedTransactionRecord transactionRecord = this.extractFirstTxIdAfterPosition(checkPointLogPosition, highestLogVersion);
        long firstTxIdAfterPosition = transactionRecord.getId();
        boolean startRecordAfterCheckpoint = firstTxIdAfterPosition != -1L || latestStartEntry != null && latestStartEntry.getStartPosition().compareTo(latestCheckPoint.getTransactionLogPosition()) >= 0;
        boolean corruptedLogs = transactionRecord.isFailure() || corruptedTransactionLogs;
        return new LogTailInformation(latestCheckPoint, corruptedLogs || startRecordAfterCheckpoint, firstTxIdAfterPosition, oldestVersionFound == -1L, highestLogVersion, latestLogEntryVersion, storeId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected ExtractedTransactionRecord extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) throws IOException {
        long initialVersion;
        long logVersion = initialVersion = initialPosition.getLogVersion();
        LogFile logFile = this.logFiles.getLogFile();
        while (logVersion <= maxLogVersion) {
            if (logFile.versionExists(logVersion)) {
                LogPosition currentPosition = logVersion != initialVersion ? logFile.extractHeader(logVersion).getStartPosition() : initialPosition;
                try (PhysicalLogVersionedStoreChannel storeChannel = logFile.openForVersion(logVersion);){
                    storeChannel.position(currentPosition.getByteOffset());
                    try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, (ReadableClosablePositionAwareChecksumChannel)new ReadAheadLogChannel(storeChannel, this.memoryTracker));){
                        while (true) {
                            if (cursor.next()) {
                                LogEntry entry = cursor.get();
                                if (!(entry instanceof LogEntryCommit)) continue;
                                ExtractedTransactionRecord extractedTransactionRecord = new ExtractedTransactionRecord(((LogEntryCommit)entry).getTxId());
                                return extractedTransactionRecord;
                                continue;
                            }
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    this.monitor.corruptedLogFile(currentPosition.getLogVersion(), t);
                    return new ExtractedTransactionRecord(true);
                }
                logVersion = currentPosition.getLogVersion() + 1L;
                continue;
            }
            ++logVersion;
        }
        return new ExtractedTransactionRecord();
    }

    public LogTailInformation getTailInformation() throws UnderlyingStorageException {
        if (this.logTailInformation == null) {
            try {
                this.logTailInformation = this.findLogTail();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Error encountered while parsing transaction logs", (Throwable)e);
            }
        }
        return this.logTailInformation;
    }

    private static String dumpBufferToString(ByteBuffer byteBuffer) {
        byte[] data = new byte[byteBuffer.limit()];
        byteBuffer.get(data);
        return Arrays.toString(data);
    }

    private static boolean isAllZerosBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            byte[] array;
            for (byte b : array = byteBuffer.array()) {
                if (b == 0) continue;
                return false;
            }
        } else {
            while (byteBuffer.hasRemaining()) {
                if (byteBuffer.get() == 0) continue;
                return false;
            }
        }
        return true;
    }

    static class ExtractedTransactionRecord {
        private final long id;
        private final boolean failure;

        ExtractedTransactionRecord() {
            this(-1L, false);
        }

        ExtractedTransactionRecord(long txId) {
            this(txId, false);
        }

        ExtractedTransactionRecord(boolean failure) {
            this(-1L, failure);
        }

        private ExtractedTransactionRecord(long txId, boolean failure) {
            this.id = txId;
            this.failure = failure;
        }

        public long getId() {
            return this.id;
        }

        public boolean isFailure() {
            return this.failure;
        }
    }
}

