/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageReader;

public class IndexStoreViewFactory {
    private final FullScanStoreView fullScanStoreView;
    private final Locks locks;
    private final LockService lockService;
    private final Config config;
    private final Supplier<StorageReader> storageReader;
    private final LogProvider logProvider;

    public IndexStoreViewFactory(Config config, Supplier<StorageReader> storageReader, Locks locks, FullScanStoreView fullScanStoreView, LockService lockService, LogProvider logProvider) {
        this.locks = locks;
        this.lockService = lockService;
        this.config = config;
        this.storageReader = storageReader;
        this.logProvider = logProvider;
        this.fullScanStoreView = fullScanStoreView;
    }

    public IndexStoreView createTokenIndexStoreView(IndexingService.IndexProxyProvider indexProxies) {
        return new DynamicIndexStoreView(this.fullScanStoreView, this.locks, this.lockService, this.config, indexProxies, this.storageReader, this.logProvider);
    }
}

