/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class RecoveryStartInformation {
    static final RecoveryStartInformation NO_RECOVERY_REQUIRED = new RecoveryStartInformation(LogPosition.UNSPECIFIED, -1L);
    static final RecoveryStartInformation MISSING_LOGS = new RecoveryStartInformation(null, -1L, true);
    private final long firstTxIdAfterLastCheckPoint;
    private final LogPosition recoveryPosition;
    private final boolean missingLogs;

    public RecoveryStartInformation(LogPosition recoveryPosition, long firstTxIdAfterLastCheckPoint) {
        this(recoveryPosition, firstTxIdAfterLastCheckPoint, false);
    }

    private RecoveryStartInformation(LogPosition recoveryPosition, long firstTxIdAfterLastCheckPoint, boolean missingLogs) {
        this.firstTxIdAfterLastCheckPoint = firstTxIdAfterLastCheckPoint;
        this.recoveryPosition = recoveryPosition;
        this.missingLogs = missingLogs;
    }

    public boolean isRecoveryRequired() {
        return this.recoveryPosition != LogPosition.UNSPECIFIED;
    }

    long getFirstTxIdAfterLastCheckPoint() {
        return this.firstTxIdAfterLastCheckPoint;
    }

    LogPosition getRecoveryPosition() {
        return this.recoveryPosition;
    }

    boolean isMissingLogs() {
        return this.missingLogs;
    }
}

