/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexBelongsToConstraintException
extends SchemaKernelException {
    private final SchemaDescriptor descriptor;
    private final String indexName;
    private static final String MESSAGE_SCHEMA = "Index belongs to constraint: %s";
    private static final String MESSAGE_NAME = "Index belongs to constraint: `%s`";

    public IndexBelongsToConstraintException(SchemaDescriptor descriptor) {
        super((Status)Status.Schema.ForbiddenOnConstraintIndex, String.format(MESSAGE_SCHEMA, descriptor));
        this.descriptor = descriptor;
        this.indexName = null;
    }

    public IndexBelongsToConstraintException(String indexName, SchemaDescriptor descriptor) {
        super((Status)Status.Schema.ForbiddenOnConstraintIndex, String.format(MESSAGE_NAME, indexName));
        this.descriptor = descriptor;
        this.indexName = indexName;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        if (this.indexName == null) {
            return String.format(MESSAGE_SCHEMA, this.descriptor.userDescription(tokenNameLookup));
        }
        return String.format(MESSAGE_NAME, this.indexName);
    }
}

