/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Objects;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

public class KernelTransactionStamp {
    private final KernelTransactionImplementation ktx;
    private final long reuseCount;

    public KernelTransactionStamp(KernelTransactionImplementation ktx) {
        this.reuseCount = ktx.getReuseCount();
        this.ktx = ktx;
    }

    public boolean isOpen() {
        return this.ktx.isOpen() && this.reuseCount == (long)this.ktx.getReuseCount();
    }

    public boolean isClosing() {
        return this.ktx.isClosing() && this.reuseCount == (long)this.ktx.getReuseCount();
    }

    long getReuseCount() {
        return this.reuseCount;
    }

    public boolean isNotExpired() {
        return this.reuseCount == (long)this.ktx.getReuseCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KernelTransactionStamp that = (KernelTransactionStamp)o;
        return this.reuseCount == that.reuseCount && Objects.equals(this.ktx, that.ktx);
    }

    public int hashCode() {
        return Objects.hash(this.ktx, this.reuseCount);
    }
}

