/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.DefaultNodePropertyAccessor;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class FullScanStoreView
implements IndexStoreView {
    protected final LockService locks;
    protected final Supplier<StorageReader> storageEngine;
    private final Function<CursorContext, StoreCursors> storeCursorsFactory;
    protected final Config config;
    protected final JobScheduler scheduler;

    public FullScanStoreView(LockService locks, Supplier<StorageReader> storageEngine, Function<CursorContext, StoreCursors> storeCursorsFactory, Config config, JobScheduler scheduler) {
        this.locks = locks;
        this.storageEngine = storageEngine;
        this.storeCursorsFactory = storeCursorsFactory;
        this.config = config;
        this.scheduler = scheduler;
    }

    @Override
    public StoreScan visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer labelScanConsumer, boolean forceStoreScan, boolean parallelWrite, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        return new NodeStoreScan(this.config, this.storageEngine.get(), this.storeCursorsFactory, this.locks, labelScanConsumer, propertyScanConsumer, labelIds, propertyKeyIdFilter, parallelWrite, this.scheduler, cacheTracer, memoryTracker);
    }

    @Override
    public StoreScan visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer relationshipTypeScanConsumer, boolean forceStoreScan, boolean parallelWrite, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        return new RelationshipStoreScan(this.config, this.storageEngine.get(), this.storeCursorsFactory, this.locks, relationshipTypeScanConsumer, propertyScanConsumer, relationshipTypeIds, propertyKeyIdFilter, parallelWrite, this.scheduler, cacheTracer, memoryTracker);
    }

    @Override
    public NodePropertyAccessor newPropertyAccessor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return new DefaultNodePropertyAccessor(this.storageEngine.get(), cursorContext, this.storeCursorsFactory.apply(cursorContext), memoryTracker);
    }

    @Override
    public boolean isEmpty() {
        try (StorageReader reader = this.storageEngine.get();){
            boolean bl = reader.nodesGetCount(CursorContext.NULL) == 0L && reader.relationshipsGetCount(CursorContext.NULL) == 0L;
            return bl;
        }
    }
}

