/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdController;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.DefaultForceOperation;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.FileStoreProviderRegistry;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppenderFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.RecoveryThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.impl.util.monitoring.LogProgressReporter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.DefaultRecoveryService;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionLogsRecovery;
import org.neo4j.kernel.recovery.facade.DatabaseRecoveryFacade;
import org.neo4j.kernel.recovery.facade.RecoveryCriteria;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.RecoveryState;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.Clocks;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public final class Recovery {
    private Recovery() {
    }

    public static DatabaseRecoveryFacade recoveryFacade(FileSystemAbstraction fs, PageCache pageCache, Tracers tracers, Config config, MemoryTracker memoryTracker, LogProvider logProvider) {
        return new DatabaseRecoveryFacade(fs, pageCache, new DatabaseTracers(tracers), config, memoryTracker, logProvider);
    }

    public static boolean isRecoveryRequired(DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker) throws Exception {
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(config);
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();){
            boolean bl = Recovery.isRecoveryRequired((FileSystemAbstraction)fs, databaseLayout, config, memoryTracker);
            return bl;
        }
    }

    public static void performRecovery(DatabaseLayout databaseLayout, DatabaseTracers tracers, MemoryTracker memoryTracker) throws Exception {
        Objects.requireNonNull(databaseLayout);
        Config config = Config.defaults();
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
             JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = Recovery.getPageCache(config, (FileSystemAbstraction)fs, jobScheduler);){
            Recovery.performRecovery((FileSystemAbstraction)fs, pageCache, tracers, config, databaseLayout, memoryTracker);
        }
    }

    public static boolean isRecoveryRequired(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker) throws Exception {
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(config);
        Objects.requireNonNull(fs);
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();){
            boolean bl;
            block12: {
                PageCache pageCache = Recovery.getPageCache(config, fs, jobScheduler);
                try {
                    StorageEngineFactory storageEngineFactory = StorageEngineFactory.defaultStorageEngine();
                    bl = Recovery.isRecoveryRequired(fs, pageCache, databaseLayout, storageEngineFactory, config, Optional.empty(), memoryTracker);
                    if (pageCache == null) break block12;
                }
                catch (Throwable throwable) {
                    if (pageCache != null) {
                        try {
                            pageCache.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pageCache.close();
            }
            return bl;
        }
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        Recovery.performRecovery(fs, pageCache, tracers, config, databaseLayout, StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout, (PageCache)pageCache, (Configuration)config), false, memoryTracker);
    }

    public static void performRecoveryWithLogPruning(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout, (PageCache)pageCache, (Configuration)config);
        Objects.requireNonNull(fs);
        Objects.requireNonNull(pageCache);
        Objects.requireNonNull(config);
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(storageEngineFactory);
        Config recoveryConfig = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.transaction_logs_root_path, null).build();
        Recovery.performRecovery(fs, pageCache, tracers, recoveryConfig, databaseLayout, storageEngineFactory, false, (LogProvider)NullLogProvider.getInstance(), new Monitors(), Recovery.loadExtensions(), Optional.empty(), RecoveryStartupChecker.EMPTY_CHECKER, memoryTracker, Clocks.systemClock(), RecoveryPredicate.ALL, true);
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, MemoryTracker memoryTracker, RecoveryCriteria recoveryCriteria) throws IOException {
        Recovery.performRecovery(fs, pageCache, tracers, config, databaseLayout, StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout, (PageCache)pageCache, (Configuration)config), false, memoryTracker, recoveryCriteria);
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, MemoryTracker memoryTracker) throws IOException {
        Recovery.performRecovery(fs, pageCache, tracers, config, databaseLayout, storageEngineFactory, forceRunRecovery, memoryTracker, (LogProvider)NullLogProvider.getInstance(), RecoveryPredicate.ALL);
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, MemoryTracker memoryTracker, RecoveryCriteria recoveryCriteria) throws IOException {
        Recovery.performRecovery(fs, pageCache, tracers, config, databaseLayout, storageEngineFactory, forceRunRecovery, memoryTracker, (LogProvider)NullLogProvider.getInstance(), recoveryCriteria.toPredicate());
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, MemoryTracker memoryTracker, LogProvider logProvider, RecoveryCriteria recoveryCriteria) throws IOException {
        Recovery.performRecovery(fs, pageCache, tracers, config, databaseLayout, StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout, (PageCache)pageCache, (Configuration)config), false, memoryTracker, logProvider, recoveryCriteria.toPredicate());
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, MemoryTracker memoryTracker, LogProvider logProvider, RecoveryPredicate recoveryPredicate) throws IOException {
        Objects.requireNonNull(fs);
        Objects.requireNonNull(pageCache);
        Objects.requireNonNull(config);
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(storageEngineFactory);
        Config recoveryConfig = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.transaction_logs_root_path, null).build();
        Recovery.performRecovery(fs, pageCache, tracers, recoveryConfig, databaseLayout, storageEngineFactory, forceRunRecovery, logProvider, new Monitors(), Recovery.loadExtensions(), Optional.empty(), RecoveryStartupChecker.EMPTY_CHECKER, memoryTracker, Clocks.systemClock(), recoveryPredicate);
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, LogProvider logProvider, Monitors globalMonitors, Iterable<ExtensionFactory<?>> extensionFactories, Optional<LogFiles> providedLogFiles, RecoveryStartupChecker startupChecker, MemoryTracker memoryTracker, Clock clock, RecoveryPredicate recoveryPredicate) throws IOException {
        Recovery.performRecovery(fs, pageCache, tracers, config, databaseLayout, storageEngineFactory, forceRunRecovery, logProvider, globalMonitors, extensionFactories, providedLogFiles, startupChecker, memoryTracker, clock, recoveryPredicate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, LogProvider logProvider, Monitors globalMonitors, Iterable<ExtensionFactory<?>> extensionFactories, Optional<LogFiles> providedLogFiles, RecoveryStartupChecker startupChecker, MemoryTracker memoryTracker, Clock clock, RecoveryPredicate recoveryPredicate, boolean pruneLogs) throws IOException {
        Log recoveryLog = logProvider.getLog(Recovery.class);
        if (!forceRunRecovery && !Recovery.isRecoveryRequired(fs, pageCache, databaseLayout, storageEngineFactory, config, providedLogFiles, memoryTracker)) {
            return;
        }
        Recovery.checkAllFilesPresence(databaseLayout, fs, pageCache, storageEngineFactory);
        LifeSupport recoveryLife = new LifeSupport();
        NamedDatabaseId namedDatabaseId = Recovery.createRecoveryDatabaseId(fs, pageCache, databaseLayout, storageEngineFactory);
        Monitors monitors = new Monitors(globalMonitors, logProvider);
        DatabasePageCache databasePageCache = new DatabasePageCache(pageCache, IOController.DISABLED);
        SimpleLogService logService = new SimpleLogService(logProvider);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(storageEngineFactory.commandReaderFactory());
        DatabaseReadOnlyChecker readOnlyChecker = DatabaseReadOnlyChecker.writable();
        DatabaseSchemaState schemaState = new DatabaseSchemaState(logProvider);
        JobScheduler scheduler = (JobScheduler)recoveryLife.add((Lifecycle)JobSchedulerFactory.createInitialisedScheduler());
        RecoveryAvailabilityGuard guard = new RecoveryAvailabilityGuard(namedDatabaseId, clock, recoveryLog);
        recoveryLife.add((Lifecycle)guard);
        VersionContextSupplier versionContextSupplier = EmptyVersionContextSupplier.EMPTY;
        DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, recoveryLog);
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
        RecoveryCleanupWorkCollector recoveryCleanupCollector = (RecoveryCleanupWorkCollector)recoveryLife.add((Lifecycle)new GroupingRecoveryCleanupWorkCollector(scheduler, Group.INDEX_CLEANUP, Group.INDEX_CLEANUP_WORK, databaseLayout.getDatabaseName()));
        DatabaseExtensions extensions = (DatabaseExtensions)recoveryLife.add((Lifecycle)Recovery.instantiateRecoveryExtensions(databaseLayout, fs, config, (LogService)logService, databasePageCache, scheduler, DbmsInfo.TOOL, monitors, tokenHolders, recoveryCleanupCollector, readOnlyChecker, extensionFactories, guard, tracers, namedDatabaseId));
        StaticIndexProviderMap indexProviderMap = (StaticIndexProviderMap)recoveryLife.add((Lifecycle)StaticIndexProviderMapFactory.create(recoveryLife, config, databasePageCache, fs, (LogService)logService, monitors, readOnlyChecker, DbmsInfo.TOOL, recoveryCleanupCollector, tracers.getPageCacheTracer(), databaseLayout, tokenHolders, scheduler, (DependencyResolver)extensions));
        StorageEngine storageEngine = storageEngineFactory.instantiate(fs, databaseLayout, config, (PageCache)databasePageCache, tokenHolders, (SchemaState)schemaState, (ConstraintRuleAccessor)ConstraintSemantics.getConstraintSemantics(), (IndexConfigCompleter)indexProviderMap, LockService.NO_LOCK_SERVICE, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, recoveryCleanupCollector, databaseLayout.getDatabaseName()), (IdController)new DefaultIdController(), databaseHealth, logService.getInternalLogProvider(), logService.getUserLogProvider(), recoveryCleanupCollector, tracers.getPageCacheTracer(), true, readOnlyChecker, memoryTracker);
        FullScanStoreView fullScanStoreView = new FullScanStoreView(LockService.NO_LOCK_SERVICE, () -> ((StorageEngine)storageEngine).newReader(), arg_0 -> ((StorageEngine)storageEngine).createStorageCursors(arg_0), config, scheduler);
        IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory(config, arg_0 -> ((StorageEngine)storageEngine).createStorageCursors(arg_0), () -> ((StorageEngine)storageEngine).newReader(), Locks.NO_LOCKS, fullScanStoreView, LockService.NO_LOCK_SERVICE, logProvider);
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(databasePageCache, databaseLayout, recoveryCleanupCollector, readOnlyChecker, tracers.getPageCacheTracer());
        IndexingService indexingService = Database.buildIndexingService(storageEngine, schemaState, indexStoreViewFactory, indexStatisticsStore, config, scheduler, indexProviderMap, (TokenNameLookup)tokenHolders, logProvider, logProvider, (IndexMonitor)monitors.newMonitor(IndexMonitor.class, new String[0]), tracers.getPageCacheTracer(), memoryTracker, databaseLayout.getDatabaseName(), readOnlyChecker);
        MetadataProvider metadataProvider = storageEngine.metadataProvider();
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{databaseLayout, config, databasePageCache, fs, logProvider, tokenHolders, schemaState, ConstraintSemantics.getConstraintSemantics(), LockService.NO_LOCK_SERVICE, databaseHealth, new DefaultIdGeneratorFactory(fs, recoveryCleanupCollector, databaseLayout.getDatabaseName()), new DefaultIdController(), readOnlyChecker, versionContextSupplier, logService, metadataProvider});
        LogFiles logFiles = LogFilesBuilder.builder(databaseLayout, fs).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(config).withDependencies((DependencyResolver)dependencies).withMemoryTracker(memoryTracker).build();
        boolean failOnCorruptedLogFiles = (Boolean)config.get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files);
        Recovery.validateStoreId(logFiles, storageEngine.getStoreId(), config);
        TransactionMetadataCache metadataCache = new TransactionMetadataCache();
        PhysicalLogicalTransactionStore transactionStore = new PhysicalLogicalTransactionStore(logFiles, metadataCache, (LogEntryReader)logEntryReader, monitors, failOnCorruptedLogFiles, config);
        TransactionAppender transactionAppender = TransactionAppenderFactory.createTransactionAppender(logFiles, (TransactionIdStore)metadataProvider, metadataCache, config, (Health)databaseHealth, scheduler, logProvider);
        LifeSupport schemaLife = new LifeSupport();
        schemaLife.add(storageEngine.schemaAndTokensLifecycle());
        schemaLife.add((Lifecycle)indexingService);
        Boolean doParallelRecovery = (Boolean)config.get(GraphDatabaseInternalSettings.do_parallel_recovery);
        TransactionLogsRecovery transactionLogsRecovery = Recovery.transactionLogRecovery(fs, (TransactionIdStore)metadataProvider, (RecoveryMonitor)monitors.newMonitor(RecoveryMonitor.class, new String[0]), (RecoveryStartInformationProvider.Monitor)monitors.newMonitor(RecoveryStartInformationProvider.Monitor.class, new String[0]), logFiles, storageEngine, transactionStore, (LogVersionRepository)metadataProvider, (Lifecycle)schemaLife, databaseLayout, failOnCorruptedLogFiles, recoveryLog, startupChecker, tracers.getPageCacheTracer(), memoryTracker, doParallelRecovery, recoveryPredicate);
        DefaultForceOperation forceOperation = new DefaultForceOperation(indexingService, storageEngine);
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        LogPruning logPruning = pruneLogs ? new LogPruningImpl(fs, logFiles, logProvider, new LogPruneStrategyFactory(), clock, config, new ReentrantLock()) : LogPruning.NO_PRUNING;
        CheckPointerImpl checkPointer = new CheckPointerImpl(metadataProvider, RecoveryThreshold.INSTANCE, forceOperation, logPruning, checkpointAppender, (Health)databaseHealth, logProvider, tracers, IOController.DISABLED, new StoreCopyCheckPointMutex(), versionContextSupplier, clock);
        recoveryLife.add((Lifecycle)storageEngine);
        recoveryLife.add((Lifecycle)new MissingTransactionLogsCheck(databaseLayout, config, fs, logFiles, recoveryLog));
        recoveryLife.add((Lifecycle)logFiles);
        recoveryLife.add((Lifecycle)transactionLogsRecovery);
        recoveryLife.add((Lifecycle)transactionAppender);
        recoveryLife.add((Lifecycle)checkPointer);
        try {
            recoveryLife.start();
            if (databaseHealth.isHealthy()) {
                checkPointer.forceCheckPoint(new SimpleTriggerInfo("Recovery completed."));
            }
        }
        finally {
            recoveryLife.shutdown();
        }
    }

    private static NamedDatabaseId createRecoveryDatabaseId(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory) {
        UUID uuid = storageEngineFactory.databaseIdUuid(fs, databaseLayout, pageCache, CursorContext.NULL).orElse(new UUID(0L, 0L));
        return DatabaseIdFactory.from((String)databaseLayout.getDatabaseName(), (UUID)uuid);
    }

    public static void validateStoreId(LogFiles logFiles, StoreId storeId, Config config) {
        StoreId txStoreId;
        if (!(((Boolean)config.get(GraphDatabaseInternalSettings.recovery_ignore_store_id_validation)).booleanValue() || StoreId.UNKNOWN.equals((Object)(txStoreId = logFiles.getTailInformation().lastStoreId)) || storeId.equalsIgnoringVersion((Object)txStoreId))) {
            throw new RuntimeException("Mismatching store id. Store StoreId: " + storeId + ". Transaction log StoreId: " + txStoreId);
        }
    }

    private static void checkAllFilesPresence(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        StorageFilesState state = storageEngineFactory.checkStoreFileState(fs, databaseLayout, pageCache);
        if (state.getRecoveryState() == RecoveryState.UNRECOVERABLE) {
            throw new RuntimeException(String.format("Store files %s is(are) missing and recovery is not possible. Please restore from a consistent backup.", state.getMissingFiles()));
        }
    }

    private static TransactionLogsRecovery transactionLogRecovery(FileSystemAbstraction fileSystemAbstraction, TransactionIdStore transactionIdStore, RecoveryMonitor recoveryMonitor, RecoveryStartInformationProvider.Monitor positionMonitor, LogFiles logFiles, StorageEngine storageEngine, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, Lifecycle schemaLife, DatabaseLayout databaseLayout, boolean failOnCorruptedLogFiles, Log log, RecoveryStartupChecker startupChecker, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, boolean doParallelRecovery, RecoveryPredicate recoveryPredicate) {
        DefaultRecoveryService recoveryService = new DefaultRecoveryService(storageEngine, transactionIdStore, logicalTransactionStore, logVersionRepository, logFiles, positionMonitor, log, doParallelRecovery);
        CorruptedLogsTruncator logsTruncator = new CorruptedLogsTruncator(databaseLayout.databaseDirectory(), logFiles, fileSystemAbstraction, memoryTracker);
        LogProgressReporter progressReporter = new LogProgressReporter(log);
        return new TransactionLogsRecovery(recoveryService, logsTruncator, schemaLife, recoveryMonitor, progressReporter, failOnCorruptedLogFiles, startupChecker, recoveryPredicate, pageCacheTracer);
    }

    private static Iterable<ExtensionFactory<?>> loadExtensions() {
        return Iterables.cast((Iterable)Services.loadAll(ExtensionFactory.class));
    }

    private static DatabaseExtensions instantiateRecoveryExtensions(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, Config config, LogService logService, PageCache pageCache, JobScheduler jobScheduler, DbmsInfo dbmsInfo, Monitors monitors, TokenHolders tokenHolders, RecoveryCleanupWorkCollector recoveryCleanupCollector, DatabaseReadOnlyChecker readOnlyChecker, Iterable<ExtensionFactory<?>> extensionFactories, AvailabilityGuard availabilityGuard, DatabaseTracers tracers, NamedDatabaseId namedDatabaseId) {
        List<ExtensionFactory<?>> recoveryExtensions = Iterables.stream(extensionFactories).filter(extension -> extension.getClass().isAnnotationPresent(RecoveryExtension.class)).collect(Collectors.toList());
        Dependencies deps = new Dependencies();
        NonListenableMonitors nonListenableMonitors = new NonListenableMonitors(monitors, logService.getInternalLogProvider());
        deps.satisfyDependencies(new Object[]{fileSystem, config, logService, pageCache, nonListenableMonitors, jobScheduler, tokenHolders, recoveryCleanupCollector, tracers, databaseLayout, readOnlyChecker, availabilityGuard, namedDatabaseId, FileStoreProviderRegistry.EMPTY});
        DatabaseExtensionContext extensionContext = new DatabaseExtensionContext(databaseLayout, dbmsInfo, (DependencySatisfier)deps);
        return new DatabaseExtensions(extensionContext, recoveryExtensions, deps, ExtensionFailureStrategies.fail());
    }

    public static boolean isRecoveryRequired(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, Config config, Optional<LogFiles> logFiles, MemoryTracker memoryTracker) throws IOException {
        RecoveryRequiredChecker requiredChecker = new RecoveryRequiredChecker(fs, pageCache, config, storageEngineFactory);
        return logFiles.isPresent() ? requiredChecker.isRecoveryRequiredAt(databaseLayout, logFiles.get()) : requiredChecker.isRecoveryRequiredAt(databaseLayout, memoryTracker);
    }

    private static PageCache getPageCache(Config config, FileSystemAbstraction fs, JobScheduler jobScheduler) {
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), jobScheduler, Clocks.nanoClock(), new MemoryPools());
        return pageCacheFactory.getOrCreatePageCache();
    }

    static void throwUnableToCleanRecover(Throwable t) {
        throw new RuntimeException("Error reading transaction logs, recovery not possible. To force the database to start anyway, you can specify '" + GraphDatabaseInternalSettings.fail_on_corrupted_log_files.name() + "=false'. This will try to recover as much as possible and then truncate the corrupt part of the transaction log. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", t);
    }

    private static class MissingTransactionLogsCheck
    extends LifecycleAdapter {
        private final DatabaseLayout databaseLayout;
        private final Config config;
        private final FileSystemAbstraction fs;
        private final LogFiles logFiles;
        private final Log log;

        MissingTransactionLogsCheck(DatabaseLayout databaseLayout, Config config, FileSystemAbstraction fs, LogFiles logFiles, Log log) {
            this.databaseLayout = databaseLayout;
            this.config = config;
            this.fs = fs;
            this.logFiles = logFiles;
            this.log = log;
        }

        public void init() throws IOException {
            this.checkForMissingLogFiles();
        }

        private void checkForMissingLogFiles() throws IOException {
            if (this.logFiles.getTailInformation().logsMissing()) {
                if (((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                    this.log.error("Transaction logs are missing and recovery is not possible.");
                    this.log.info("To force the database to start anyway, you can specify '%s=false'. This will create new transaction log and will update database metadata accordingly. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", new Object[]{GraphDatabaseSettings.fail_on_missing_files.name()});
                    Path[] logFiles = this.findLegacyLogFiles();
                    if (logFiles.length > 0) {
                        this.log.warn("Transaction log files were found in database directory, rather than the transaction log directory.");
                        this.log.warn("Please move or remove the following %s misplaced transaction log file or files:", new Object[]{logFiles.length});
                        for (Path logFile : logFiles) {
                            this.log.warn(logFile.toAbsolutePath().toString());
                        }
                    }
                    throw new RuntimeException("Transaction logs are missing and recovery is not possible.");
                }
                this.log.warn("No transaction logs were detected, but recovery was forced by user.");
            }
        }

        private Path[] findLegacyLogFiles() throws IOException {
            LegacyTransactionLogsLocator locator = new LegacyTransactionLogsLocator(Config.defaults(), this.databaseLayout);
            Path logsDirectory = locator.getTransactionLogsDirectory();
            TransactionLogFilesHelper logFilesHelper = new TransactionLogFilesHelper(this.fs, logsDirectory);
            return logFilesHelper.getMatchedFiles();
        }
    }

    private static class NonListenableMonitors
    extends Monitors {
        NonListenableMonitors(Monitors monitors, LogProvider logProvider) {
            super(monitors, logProvider);
        }

        public void addMonitorListener(Object monitorListener, String ... tags) {
        }
    }

    private static class RecoveryAvailabilityGuard
    extends DatabaseAvailabilityGuard {
        RecoveryAvailabilityGuard(NamedDatabaseId namedDatabaseId, Clock clock, Log log) {
            super(namedDatabaseId, clock, log, 0L, new CompositeDatabaseAvailabilityGuard(clock));
            this.init();
            this.start();
        }

        @Override
        public void addListener(AvailabilityListener listener) {
            super.addListener(listener);
            listener.available();
        }
    }
}

