/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.LongSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogFileCreateEvent;

public class TransactionLogChannelAllocator {
    private final TransactionLogFilesContext logFilesContext;
    private final FileSystemAbstraction fileSystem;
    private final TransactionLogFilesHelper fileHelper;
    private final LogHeaderCache logHeaderCache;
    private final ChannelNativeAccessor nativeChannelAccessor;
    private final DatabaseTracer databaseTracer;

    public TransactionLogChannelAllocator(TransactionLogFilesContext logFilesContext, TransactionLogFilesHelper fileHelper, LogHeaderCache logHeaderCache, ChannelNativeAccessor nativeChannelAccessor) {
        this.logFilesContext = logFilesContext;
        this.fileSystem = logFilesContext.getFileSystem();
        this.databaseTracer = logFilesContext.getDatabaseTracers().getDatabaseTracer();
        this.fileHelper = fileHelper;
        this.logHeaderCache = logHeaderCache;
        this.nativeChannelAccessor = nativeChannelAccessor;
    }

    public PhysicalLogVersionedStoreChannel createLogChannel(long version, LongSupplier lastCommittedTransactionId) throws IOException {
        AllocatedFile allocatedFile = this.allocateFile(version);
        StoreChannel storeChannel = allocatedFile.getStoreChannel();
        Path logFile = allocatedFile.getPath();
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(64, this.logFilesContext.getMemoryTracker());){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            LogHeader header = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)storeChannel, false, logFile);
            if (header == null) {
                try (LogFileCreateEvent ignored = this.databaseTracer.createLogFile();){
                    storeChannel.position(0L);
                    long lastTxId = lastCommittedTransactionId.getAsLong();
                    LogHeader logHeader = new LogHeader(version, lastTxId, this.logFilesContext.getStoreId());
                    LogHeaderWriter.writeLogHeader(storeChannel, logHeader, this.logFilesContext.getMemoryTracker());
                    this.logHeaderCache.putHeader(version, logHeader);
                }
            }
            byte formatVersion = header == null ? (byte)7 : (byte)header.getLogFormatVersion();
            PhysicalLogVersionedStoreChannel physicalLogVersionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, version, formatVersion, logFile, this.nativeChannelAccessor, this.databaseTracer);
            return physicalLogVersionedStoreChannel;
        }
    }

    public PhysicalLogVersionedStoreChannel openLogChannel(long version) throws IOException {
        return this.openLogChannel(version, false);
    }

    public PhysicalLogVersionedStoreChannel openLogChannel(long version, boolean raw) throws IOException {
        PhysicalLogVersionedStoreChannel physicalLogVersionedStoreChannel;
        Path fileToOpen = this.fileHelper.getLogFileForVersion(version);
        if (!this.fileSystem.fileExists(fileToOpen)) {
            throw new NoSuchFileException(fileToOpen.toAbsolutePath().toString());
        }
        StoreChannel rawChannel = null;
        rawChannel = this.fileSystem.read(fileToOpen);
        HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(64, this.logFilesContext.getMemoryTracker());
        try {
            ByteBuffer buffer = scopedBuffer.getBuffer();
            LogHeader header = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)rawChannel, true, fileToOpen);
            if (header == null || header.getLogVersion() != version) {
                throw new IllegalStateException(String.format("Unexpected log file header. Expected header version: %d, actual header: %s", version, header != null ? header.toString() : "null header."));
            }
            PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(rawChannel, version, header.getLogFormatVersion(), fileToOpen, this.nativeChannelAccessor, this.databaseTracer, raw);
            if (!raw) {
                this.nativeChannelAccessor.adviseSequentialAccessAndKeepInCache(rawChannel, version);
            }
            physicalLogVersionedStoreChannel = versionedStoreChannel;
        }
        catch (Throwable buffer) {
            try {
                try {
                    scopedBuffer.close();
                }
                catch (Throwable throwable) {
                    buffer.addSuppressed(throwable);
                }
                throw buffer;
            }
            catch (NoSuchFileException cause) {
                throw (NoSuchFileException)new NoSuchFileException(fileToOpen.toAbsolutePath().toString()).initCause(cause);
            }
            catch (Throwable unexpectedError) {
                if (rawChannel != null) {
                    try {
                        rawChannel.close();
                    }
                    catch (IOException e) {
                        unexpectedError.addSuppressed(e);
                    }
                }
                throw unexpectedError;
            }
        }
        scopedBuffer.close();
        return physicalLogVersionedStoreChannel;
    }

    private AllocatedFile allocateFile(long version) throws IOException {
        Path file = this.fileHelper.getLogFileForVersion(version);
        boolean fileExist = this.fileSystem.fileExists(file);
        StoreChannel storeChannel = this.fileSystem.write(file);
        if (fileExist) {
            this.nativeChannelAccessor.adviseSequentialAccessAndKeepInCache(storeChannel, version);
        } else if (this.logFilesContext.getTryPreallocateTransactionLogs().get()) {
            this.nativeChannelAccessor.preallocateSpace(storeChannel, version);
        }
        return new AllocatedFile(file, storeChannel);
    }

    private static class AllocatedFile {
        private final Path path;
        private final StoreChannel storeChannel;

        AllocatedFile(Path path, StoreChannel storeChannel) {
            this.path = path;
            this.storeChannel = storeChannel;
        }

        public Path getPath() {
            return this.path;
        }

        public StoreChannel getStoreChannel() {
            return this.storeChannel;
        }
    }
}

