/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class WorkSyncedIndexPopulator
extends IndexPopulator.Delegating {
    private final WorkSync<IndexUpdateApply, IndexUpdateWork> workSync = new WorkSync((Object)new IndexUpdateApply());

    public WorkSyncedIndexPopulator(IndexPopulator delegate) {
        super(delegate);
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        if (updates.isEmpty()) {
            return;
        }
        try {
            this.workSync.apply((Work)new IndexUpdateWork(updates, cursorContext));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new UncheckedIOException((IOException)cause);
            }
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private class IndexUpdateWork
    implements Work<IndexUpdateApply, IndexUpdateWork> {
        private final Collection<? extends IndexEntryUpdate<?>> updates;
        private final CursorContext cursorContext;

        IndexUpdateWork(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
            this.updates = updates;
            this.cursorContext = cursorContext;
        }

        public IndexUpdateWork combine(IndexUpdateWork work) {
            ArrayList combined = new ArrayList(this.updates);
            combined.addAll(work.updates);
            return new IndexUpdateWork(combined, this.cursorContext);
        }

        public void apply(IndexUpdateApply indexUpdateApply) throws Exception {
            indexUpdateApply.process(this.updates, this.cursorContext);
        }
    }

    private class IndexUpdateApply {
        private IndexUpdateApply() {
        }

        void process(Collection<? extends IndexEntryUpdate<?>> indexEntryUpdates, CursorContext cursorContext) throws Exception {
            WorkSyncedIndexPopulator.super.add(indexEntryUpdates, cursorContext);
        }
    }
}

