/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.Objects;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.graphdb.impl.notification.NotificationCodeWithDescription;
import org.neo4j.kernel.api.exceptions.Status;

public final class NotificationImplementation
implements Notification {
    private final Status.Code statusCode;
    private final String title;
    private final String description;
    private final SeverityLevel severity;
    private final NotificationCategory category;
    private final InputPosition position;
    private final String message;

    NotificationImplementation(NotificationCodeWithDescription notificationCodeWithDescription, InputPosition position, String title, String description, String message) {
        this.statusCode = notificationCodeWithDescription.getStatus().code();
        if (!(this.statusCode instanceof Status.NotificationCode)) {
            throw new IllegalStateException("'" + this.statusCode + "' is not a notification code.");
        }
        this.severity = this.mapSeverity(((Status.NotificationCode)this.statusCode).getSeverity());
        this.category = this.mapCategory(((Status.NotificationCode)this.statusCode).getNotificationCategory());
        this.position = position;
        this.title = title;
        this.description = description;
        this.message = message;
    }

    public String getCode() {
        return this.statusCode.serialize();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public InputPosition getPosition() {
        return this.position;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }

    public SeverityLevel getSeverity() {
        return this.severity;
    }

    public String toString() {
        return "Notification{position=" + this.position + ", description='" + this.description + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationImplementation that = (NotificationImplementation)o;
        return Objects.equals(this.position, that.position) && Objects.equals(this.description, that.description) && Objects.equals(this.title, that.title) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.description, this.title, this.message);
    }

    private SeverityLevel mapSeverity(String severityLevel) {
        return SeverityLevel.valueOf((String)severityLevel);
    }

    private NotificationCategory mapCategory(String category) {
        return NotificationCategory.valueOf((String)category);
    }

    public String getMessage() {
        return this.message;
    }

    public static class NotificationBuilder {
        private final NotificationCodeWithDescription notificationCodeWithDescription;
        private String title;
        private final String description;
        private InputPosition position;
        private final String message;
        private String[] messageParameters;
        private String[] notificationDetails;

        public NotificationBuilder(NotificationCodeWithDescription notificationCodeWithDescription) {
            this.notificationCodeWithDescription = notificationCodeWithDescription;
            this.description = notificationCodeWithDescription.getDescription();
            this.title = notificationCodeWithDescription.getStatus().code().description();
            this.position = InputPosition.empty;
            this.message = notificationCodeWithDescription.getMessage();
        }

        public NotificationBuilder setPosition(InputPosition position) {
            this.position = position;
            return this;
        }

        public NotificationBuilder setTitleDetails(String ... details) {
            if (details.length > 0) {
                this.title = String.format(this.title, details);
            }
            return this;
        }

        public NotificationBuilder setNotificationDetails(String ... details) {
            this.notificationDetails = details;
            return this;
        }

        public NotificationBuilder setMessageParameters(String ... parameters) {
            this.messageParameters = parameters;
            return this;
        }

        public NotificationImplementation build() {
            String detailedDescription = this.description;
            if (this.notificationDetails != null) {
                detailedDescription = String.format(this.description, this.notificationDetails);
            }
            String detailedMessage = this.message;
            if (this.messageParameters != null) {
                detailedMessage = String.format(this.message, this.messageParameters);
            }
            return new NotificationImplementation(this.notificationCodeWithDescription, this.position, this.title, detailedDescription, detailedMessage);
        }
    }
}

