/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJob;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.InternalLogProvider;

public class OnlineIndexSamplingJobFactory
implements IndexSamplingJobFactory {
    private final IndexStatisticsStore indexStatisticsStore;
    private final InternalLogProvider logProvider;
    private final TokenNameLookup nameLookup;
    private final CursorContextFactory contextFactory;

    public OnlineIndexSamplingJobFactory(IndexStatisticsStore indexStatisticsStore, TokenNameLookup nameLookup, InternalLogProvider logProvider, CursorContextFactory contextFactory) {
        this.indexStatisticsStore = indexStatisticsStore;
        this.logProvider = logProvider;
        this.nameLookup = nameLookup;
        this.contextFactory = contextFactory;
    }

    @Override
    public IndexSamplingJob create(long indexId, IndexProxy indexProxy) {
        String indexUserDescription = indexProxy.getDescriptor().userDescription(this.nameLookup);
        String indexName = indexProxy.getDescriptor().getName();
        return new OnlineIndexSamplingJob(indexId, indexProxy, this.indexStatisticsStore, indexUserDescription, indexName, this.logProvider, this.contextFactory);
    }
}

