/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.StatementInfo;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class ExecutingQueryFactory {
    private static final AtomicLong lastQueryId = new AtomicLong();
    private final SystemNanoClock clock;
    private final AtomicReference<CpuClock> cpuClockRef;

    public ExecutingQueryFactory(SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef) {
        this.clock = clock;
        this.cpuClockRef = cpuClockRef;
    }

    public ExecutingQuery createForStatement(StatementInfo statement, String queryText, MapValue queryParameters) {
        ExecutingQuery executingQuery = this.createUnbound(queryText, queryParameters, statement.clientInfo(), statement.executingUser(), statement.authenticatedUser(), statement.getMetaData());
        ExecutingQueryFactory.bindToStatement(executingQuery, statement);
        return executingQuery;
    }

    public ExecutingQuery createUnbound(String queryText, MapValue queryParameters, ClientConnectionInfo clientConnectionInfo, String executingUser, String authenticatedUser, Map<String, Object> transactionMetaData) {
        Thread thread = Thread.currentThread();
        return new ExecutingQuery(lastQueryId.incrementAndGet(), clientConnectionInfo, executingUser, authenticatedUser, queryText, queryParameters, transactionMetaData, thread.getId(), thread.getName(), this.clock, this.cpuClockRef.get());
    }

    public static void bindToStatement(ExecutingQuery executingQuery, StatementInfo statement) {
        executingQuery.onTransactionBound(new ExecutingQuery.TransactionBinding(statement.namedDatabaseId(), statement::getHits, statement::getFaults, statement::activeLockCount, statement.getTransactionSequenceNumber()));
    }

    public static void unbindFromTransaction(ExecutingQuery executingQuery, long userTransactionId) {
        executingQuery.onTransactionUnbound(userTransactionId);
    }
}

