/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.LongConsumer;
import org.neo4j.common.HexPrinter;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class TransactionToApply
implements CommandsToApply,
AutoCloseable {
    public static final long TRANSACTION_ID_NOT_SPECIFIED = 0L;
    private final TransactionRepresentation transactionRepresentation;
    private long transactionId;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private TransactionToApply nextTransactionInBatch;
    private Commitment commitment;
    private LongConsumer closedCallback;

    public TransactionToApply(TransactionRepresentation transactionRepresentation, CursorContext cursorContext, StoreCursors storeCursors) {
        this(transactionRepresentation, 0L, cursorContext, storeCursors);
    }

    public TransactionToApply(TransactionRepresentation transactionRepresentation, long transactionId, CursorContext cursorContext, StoreCursors storeCursors) {
        this.transactionRepresentation = transactionRepresentation;
        this.transactionId = transactionId;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
    }

    public void next(TransactionToApply next) {
        this.nextTransactionInBatch = next;
    }

    public void publishAsCommitted() {
        this.commitment.publishAsCommitted();
    }

    public void publishAsClosed() {
        if (this.commitment.markedAsCommitted()) {
            this.commitment.publishAsClosed();
        }
    }

    public long transactionId() {
        return this.transactionId;
    }

    public Subject subject() {
        return this.transactionRepresentation.getSubject();
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public StoreCursors storeCursors() {
        return this.storeCursors;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        return this.transactionRepresentation.accept(visitor);
    }

    public TransactionRepresentation transactionRepresentation() {
        return this.transactionRepresentation;
    }

    public void commitment(Commitment commitment, long transactionId) {
        this.commitment = commitment;
        this.transactionId = transactionId;
        this.cursorContext.getVersionContext().initWrite(transactionId);
    }

    public TransactionToApply next() {
        return this.nextTransactionInBatch;
    }

    public void onClose(LongConsumer closedCallback) {
        this.closedCallback = closedCallback;
    }

    @Override
    public void close() {
        if (this.closedCallback != null) {
            this.closedCallback.accept(this.transactionId);
        }
    }

    public String toString() {
        TransactionRepresentation tr = this.transactionRepresentation;
        return "Transaction #" + this.transactionId + " {started " + Format.date((long)tr.getTimeStarted()) + ", committed " + Format.date((long)tr.getTimeCommitted()) + ", with " + this.countCommands() + " commands in this transaction, lease " + tr.getLeaseId() + ", latest committed transaction id when started was " + tr.getLatestCommittedTxWhenStarted() + ", additional header bytes: " + HexPrinter.hex((byte[])tr.additionalHeader(), (int)Integer.MAX_VALUE, (String)"") + "}";
    }

    private String countCommands() {
        try {
            class Counter
            implements Visitor<StorageCommand, IOException> {
                private int count;

                Counter() {
                }

                public boolean visit(StorageCommand element) {
                    ++this.count;
                    return false;
                }
            }
            Counter counter = new Counter();
            this.accept(counter);
            return String.valueOf(counter.count);
        }
        catch (Throwable e) {
            return "(unable to count: " + e.getMessage() + ")";
        }
    }

    public Iterator<StorageCommand> iterator() {
        return this.transactionRepresentation.iterator();
    }
}

