/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextCursorTracer;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ThreadExecutionContext
implements ExecutionContext,
AutoCloseable {
    private final CursorContext context;
    private final OverridableSecurityContext overridableSecurityContext;
    private final ExecutionContextCursorTracer cursorTracer;
    private final CursorContext ktxContext;
    private final AllStoreHolder.ForThreadExecutionContextScope allStoreHolder;
    private final TokenRead tokenRead;
    private final StoreCursors storageCursors;
    private final IndexMonitor monitor;
    private final MemoryTracker contextTracker;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final List<AutoCloseable> otherResources;

    public ThreadExecutionContext(CursorContext context, OverridableSecurityContext overridableSecurityContext, ExecutionContextCursorTracer cursorTracer, CursorContext ktxContext, AllStoreHolder.ForThreadExecutionContextScope allStoreHolder, TokenRead tokenRead, StoreCursors storageCursors, IndexMonitor monitor, MemoryTracker contextTracker, SecurityAuthorizationHandler securityAuthorizationHandler, List<AutoCloseable> otherResources) {
        this.context = context;
        this.overridableSecurityContext = overridableSecurityContext;
        this.cursorTracer = cursorTracer;
        this.ktxContext = ktxContext;
        this.allStoreHolder = allStoreHolder;
        this.tokenRead = tokenRead;
        this.storageCursors = storageCursors;
        this.monitor = monitor;
        this.contextTracker = contextTracker;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
        this.otherResources = otherResources;
    }

    public CursorContext cursorContext() {
        return this.context;
    }

    public SecurityContext securityContext() {
        return this.overridableSecurityContext.currentSecurityContext();
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public TokenRead tokenRead() {
        return this.tokenRead;
    }

    public Procedures procedures() {
        return this.allStoreHolder;
    }

    public void complete() {
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>(this.otherResources);
        resources.add((AutoCloseable)this.storageCursors);
        IOUtils.closeAllUnchecked(resources);
        this.cursorTracer.complete();
    }

    public void report() {
        this.mergeBlocked(this.cursorTracer);
    }

    public StoreCursors storeCursors() {
        return this.storageCursors;
    }

    public QueryContext queryContext() {
        return this.allStoreHolder;
    }

    public MemoryTracker memoryTracker() {
        return this.contextTracker;
    }

    public Locks locks() {
        return this.allStoreHolder;
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.securityAuthorizationHandler;
    }

    IndexMonitor monitor() {
        return this.monitor;
    }

    @Override
    public void close() {
        while (!this.cursorTracer.isCompleted()) {
            Thread.onSpinWait();
        }
        this.mergeUnblocked(this.cursorTracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeBlocked(ExecutionContextCursorTracer cursorTracer) {
        CursorContext cursorContext = this.ktxContext;
        synchronized (cursorContext) {
            this.mergeUnblocked(cursorTracer);
        }
        VarHandle.fullFence();
    }

    private void mergeUnblocked(ExecutionContextCursorTracer cursorTracer) {
        this.ktxContext.merge(cursorTracer.snapshot());
    }
}

