/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class IndexCreatorImpl
implements IndexCreator {
    private final Collection<String> propertyKeys;
    private final Label[] labels;
    private final RelationshipType[] types;
    private final InternalSchemaActions actions;
    private final String indexName;
    private final IndexType indexType;
    private final IndexConfig indexConfig;

    public IndexCreatorImpl(InternalSchemaActions actions, Label ... labels) {
        this(actions, labels, null, null, new ArrayList<String>(), IndexType.RANGE, IndexConfig.empty());
    }

    public IndexCreatorImpl(InternalSchemaActions actions, RelationshipType ... types) {
        this(actions, null, types, null, new ArrayList<String>(), IndexType.RANGE, IndexConfig.empty());
    }

    private IndexCreatorImpl(InternalSchemaActions actions, Label[] labels, RelationshipType[] types, String indexName, Collection<String> propertyKeys, IndexType indexType, IndexConfig indexConfig) {
        this.actions = actions;
        this.labels = labels;
        this.types = types;
        this.indexName = indexName;
        this.propertyKeys = propertyKeys;
        this.indexType = indexType;
        this.indexConfig = indexConfig;
        this.assertInUnterminatedTransaction();
    }

    public IndexCreator on(String propertyKey) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.labels, this.types, this.indexName, IndexCreatorImpl.copyAndAdd(this.propertyKeys, propertyKey), this.indexType, this.indexConfig);
    }

    public IndexCreator withName(String indexName) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.labels, this.types, indexName, this.propertyKeys, this.indexType, this.indexConfig);
    }

    public IndexCreator withIndexType(IndexType indexType) {
        this.assertInUnterminatedTransaction();
        if (indexType == IndexType.LOOKUP) {
            throw new ConstraintViolationException("Index type " + indexType + " is not supported for property indexes.");
        }
        return new IndexCreatorImpl(this.actions, this.labels, this.types, this.indexName, this.propertyKeys, indexType, this.indexConfig);
    }

    public IndexCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.labels, this.types, this.indexName, this.propertyKeys, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }

    public IndexDefinition create() throws ConstraintViolationException {
        this.assertInUnterminatedTransaction();
        if (this.propertyKeys.isEmpty()) {
            throw new ConstraintViolationException("An index needs at least one property key to index");
        }
        if (this.labels != null) {
            return this.actions.createIndexDefinition(this.labels, this.indexName, this.indexType, this.indexConfig, this.propertyKeys.toArray(new String[0]));
        }
        if (this.types != null) {
            return this.actions.createIndexDefinition(this.types, this.indexName, this.indexType, this.indexConfig, this.propertyKeys.toArray(new String[0]));
        }
        throw new IllegalStateException("Must have either labels or relationship types to create an index, but neither was present.");
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }

    static List<String> copyAndAdd(Collection<String> propertyKeys, String propertyKey) {
        ArrayList<String> ret = new ArrayList<String>(propertyKeys);
        ret.add(propertyKey);
        return ret;
    }
}

