/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.api.index.stats.IndexUsageStatsConsumer;

public abstract class AbstractSwallowingIndexProxy
implements IndexProxy {
    private final IndexDescriptor indexDescriptor;
    private final IndexPopulationFailure populationFailure;

    AbstractSwallowingIndexProxy(IndexDescriptor indexDescriptor, IndexPopulationFailure populationFailure) {
        this.indexDescriptor = indexDescriptor;
        this.populationFailure = populationFailure;
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() {
        return this.populationFailure;
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.NONE;
    }

    @Override
    public void start() {
        String message = "Unable to start index, it is in a " + this.getState().name() + " state.";
        throw new UnsupportedOperationException(message + ", caused by: " + this.getPopulationFailure());
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        return SwallowingIndexUpdater.INSTANCE;
    }

    @Override
    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public void close(CursorContext cursorContext) {
    }

    @Override
    public ValueIndexReader newValueReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TokenIndexReader newTokenReader() throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reportUsageStatistics(IndexUsageStatsConsumer consumer) {
    }
}

