/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.kernel.impl.coreapi.schema.AbstractConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipKeyConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceCreator;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyTypeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyUniqueConstraintCreator;

public class BaseRelationshipConstraintCreator
extends AbstractConstraintCreator
implements ConstraintCreator {
    protected final RelationshipType type;

    BaseRelationshipConstraintCreator(InternalSchemaActions actions, String name, RelationshipType type, IndexType indexType, IndexConfig indexConfig) {
        super(actions, name, indexType, indexConfig);
        this.type = type;
    }

    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        return new RelationshipPropertyUniqueConstraintCreator(this.actions, this.name, this.type, List.of(propertyKey), this.indexType, this.indexConfig);
    }

    public ConstraintCreator assertPropertyExists(String propertyKey) {
        return new RelationshipPropertyExistenceCreator(this.actions, this.name, this.type, propertyKey, this.indexType, this.indexConfig);
    }

    public ConstraintCreator assertPropertyIsNodeKey(String propertyKey) {
        throw new UnsupportedOperationException("Node key constraints are not supported on relationships.");
    }

    public ConstraintCreator assertPropertyIsRelationshipKey(String propertyKey) {
        return new RelationshipKeyConstraintCreator(this.actions, this.name, this.type, List.of(propertyKey), this.indexType, this.indexConfig);
    }

    public ConstraintCreator assertPropertyHasType(String propertyKey, PropertyType ... propertyType) {
        PropertyTypeSet propertyTypeSet = this.validatePropertyTypes(propertyType);
        return new RelationshipPropertyTypeConstraintCreator(this.actions, this.name, this.type, propertyKey, this.indexType, this.indexConfig, propertyTypeSet);
    }

    public ConstraintCreator withName(String name) {
        return new BaseRelationshipConstraintCreator(this.actions, name, this.type, this.indexType, this.indexConfig);
    }

    public ConstraintCreator withIndexType(IndexType indexType) {
        return new BaseRelationshipConstraintCreator(this.actions, this.name, this.type, indexType, this.indexConfig);
    }

    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new BaseRelationshipConstraintCreator(this.actions, this.name, this.type, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }
}

