/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public final class EntryTimespanThreshold
implements Threshold {
    private final long timeToKeepInMillis;
    private final Clock clock;
    private final TimeUnit timeUnit;
    private final FileSizeThreshold fileSizeThreshold;
    private final InternalLog log;
    private long lowerLimit;

    EntryTimespanThreshold(InternalLogProvider logProvider, Clock clock, TimeUnit timeUnit, long timeToKeep) {
        this(logProvider, clock, timeUnit, timeToKeep, null);
    }

    EntryTimespanThreshold(InternalLogProvider logProvider, Clock clock, TimeUnit timeUnit, long timeToKeep, FileSizeThreshold fileSizeThreshold) {
        this.log = logProvider.getLog(this.getClass());
        this.clock = clock;
        this.timeUnit = timeUnit;
        this.timeToKeepInMillis = timeUnit.toMillis(timeToKeep);
        this.fileSizeThreshold = fileSizeThreshold;
    }

    @Override
    public void init() {
        if (this.fileSizeThreshold != null) {
            this.fileSizeThreshold.init();
        }
        this.lowerLimit = this.clock.millis() - this.timeToKeepInMillis;
    }

    @Override
    public boolean reached(Path file, long version, LogFileInformation source) {
        try {
            if (this.fileSizeThreshold != null && this.fileSizeThreshold.reached(file, version, source)) {
                return true;
            }
            long firstStartRecordTimestamp = source.getFirstStartRecordTimestamp(version);
            return firstStartRecordTimestamp >= 0L && firstStartRecordTimestamp < this.lowerLimit;
        }
        catch (IOException e) {
            this.log.warn("Fail to get timestamp info from transaction log file " + version, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.timeUnit.convert(this.timeToKeepInMillis, TimeUnit.MILLISECONDS) + " " + this.timeUnit.name().toLowerCase(Locale.ROOT) + (String)(this.fileSizeThreshold == null ? "" : " " + this.fileSizeThreshold);
    }
}

