/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RecoveryState;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;

class RecoveryRequiredChecker {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final StorageEngineFactory storageEngineFactory;
    private final LogTailExtractor logTailExtractor;

    RecoveryRequiredChecker(FileSystemAbstraction fs, PageCache pageCache, Config config, StorageEngineFactory storageEngineFactory, DatabaseTracers databaseTracers) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.logTailExtractor = new LogTailExtractor(fs, pageCache, config, storageEngineFactory, databaseTracers);
        this.storageEngineFactory = storageEngineFactory;
    }

    public boolean isRecoveryRequiredAt(DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        LogTailMetadata logTail = this.logTailExtractor.getTailMetadata(databaseLayout, memoryTracker);
        return this.isRecoveryRequiredAt(databaseLayout, logTail);
    }

    boolean isRecoveryRequiredAt(DatabaseLayout databaseLayout, LogTailMetadata logTailMetadata) {
        if (!this.storageEngineFactory.storageExists(this.fs, databaseLayout)) {
            return false;
        }
        StorageFilesState filesRecoveryState = this.storageEngineFactory.checkStoreFileState(this.fs, databaseLayout, this.pageCache);
        if (filesRecoveryState.getRecoveryState() != RecoveryState.RECOVERED) {
            return true;
        }
        return logTailMetadata.isRecoveryRequired();
    }
}

