/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.emitters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.compiler.CypherEmitter;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Property;

public class ExistingRelationshipEmitter
implements CypherEmitter {
    Set<Edge> edges;

    public ExistingRelationshipEmitter(Set<Edge> edges) {
        this.edges = edges;
    }

    public void emit(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (this.edges.size() > 0) {
            queryBuilder.append("START r=rel({relIds}) FOREACH (row in filter(row in {rows} where row.relId = id(r)) | SET r += row.props)");
            ArrayList<Long> relIds = new ArrayList<Long>(this.edges.size());
            ArrayList rows = new ArrayList();
            for (Edge edge : this.edges) {
                HashMap<String, Serializable> rowMap = new HashMap<String, Serializable>();
                rowMap.put("relId", edge.getId());
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (Property property : edge.getPropertyList()) {
                    props.put((String)property.getKey(), property.getValue());
                }
                rowMap.put("props", props);
                rows.add(rowMap);
                relIds.add(edge.getId());
            }
            parameters.put("rows", rows);
            parameters.put("relIds", relIds);
        }
    }
}

