/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.testutil;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.parboiled.common.StringUtils;

public final class GraphTestUtils {
    private GraphTestUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSameGraph(GraphDatabaseService graphDatabase, String sameGraphCypher) {
        GraphDatabaseService otherDatabase = new TestGraphDatabaseFactory().newImpermanentDatabase();
        otherDatabase.execute(sameGraphCypher);
        try (Transaction tx = graphDatabase.beginTx();){
            try (Transaction tx2 = otherDatabase.beginTx();){
                GraphTestUtils.doAssertSubgraph(graphDatabase, otherDatabase, "existing database");
                GraphTestUtils.doAssertSubgraph(otherDatabase, graphDatabase, "Cypher-created database");
                tx2.failure();
            }
            tx.failure();
        }
        finally {
            otherDatabase.shutdown();
        }
    }

    private static void doAssertSubgraph(GraphDatabaseService database, GraphDatabaseService otherDatabase, String firstDatabaseName) {
        Map<Long, Long[]> sameNodesMap = GraphTestUtils.buildSameNodesMap(database, otherDatabase, firstDatabaseName);
        Set<Map<Long, Long>> nodeMappings = GraphTestUtils.buildNodeMappingPermutations(sameNodesMap, otherDatabase);
        if (nodeMappings.size() == 1) {
            GraphTestUtils.assertRelationshipsMappingExistsForSingleNodeMapping(database, otherDatabase, nodeMappings.iterator().next(), firstDatabaseName);
            return;
        }
        for (Map<Long, Long> nodeMapping : nodeMappings) {
            if (!GraphTestUtils.relationshipsMappingExists(database, otherDatabase, nodeMapping)) continue;
            return;
        }
        Assert.fail((String)"There is no corresponding relationship mapping for any of the possible node mappings");
    }

    private static Set<Map<Long, Long>> buildNodeMappingPermutations(Map<Long, Long[]> sameNodesMap, GraphDatabaseService otherDatabase) {
        HashSet<Map<Long, Long>> result = new HashSet<Map<Long, Long>>();
        result.add(new HashMap());
        for (Map.Entry<Long, Long[]> entry : sameNodesMap.entrySet()) {
            HashSet newResult = new HashSet();
            for (Long target : entry.getValue()) {
                for (Map map : result) {
                    if (map.values().contains(target)) continue;
                    HashMap<Long, Long> newMapping = new HashMap<Long, Long>(map);
                    newMapping.put(entry.getKey(), target);
                    newResult.add(newMapping);
                }
            }
            if (newResult.isEmpty()) {
                Assert.fail((String)("Could not find a node corresponding to: " + GraphTestUtils.print(otherDatabase.getNodeById(entry.getKey().longValue())) + ". There are most likely more nodes with the same characteristics (labels, properties) in your " + "cypher CREATE statement but fewer in the database."));
            }
            result = newResult;
        }
        return result;
    }

    public static Iterable<Node> allNodes(GraphDatabaseService graphDatabaseService) {
        try {
            Method allNodes = GraphDatabaseService.class.getMethod("getAllNodes", new Class[0]);
            return (Iterable)allNodes.invoke((Object)graphDatabaseService, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Class<?> clazz = Class.forName("org.neo4j.tooling.GlobalGraphOperations");
                try {
                    Method at = clazz.getMethod("at", GraphDatabaseService.class);
                    Object instance = at.invoke(null, graphDatabaseService);
                    Method allNodes = instance.getClass().getMethod("getAllNodes", new Class[0]);
                    return (Iterable)allNodes.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException nsme2) {
                    throw new RuntimeException(nsme2);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    public static Iterable<Relationship> allRelationships(GraphDatabaseService graphDatabaseService) {
        try {
            Method allRelationships = GraphDatabaseService.class.getMethod("getAllRelationships", new Class[0]);
            return (Iterable)allRelationships.invoke((Object)graphDatabaseService, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Class<?> clazz = Class.forName("org.neo4j.tooling.GlobalGraphOperations");
                try {
                    Method at = clazz.getMethod("at", GraphDatabaseService.class);
                    Object instance = at.invoke(null, graphDatabaseService);
                    Method allRelationships = instance.getClass().getMethod("getAllRelationships", new Class[0]);
                    return (Iterable)allRelationships.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException nsme2) {
                    throw new RuntimeException(nsme2);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    private static Map<Long, Long[]> buildSameNodesMap(GraphDatabaseService database, GraphDatabaseService otherDatabase, String firstDatabaseName) {
        HashMap<Long, Long[]> sameNodesMap = new HashMap<Long, Long[]>();
        for (Node node : GraphTestUtils.allNodes(otherDatabase)) {
            Iterable<Node> sameNodes = GraphTestUtils.findSameNodes(database, node);
            if (!sameNodes.iterator().hasNext()) {
                Assert.fail((String)("There is no corresponding node to " + GraphTestUtils.print(node) + " in " + firstDatabaseName));
            }
            HashSet<Long> sameNodeIds = new HashSet<Long>();
            for (Node sameNode : sameNodes) {
                sameNodeIds.add(sameNode.getId());
            }
            sameNodesMap.put(node.getId(), sameNodeIds.toArray(new Long[sameNodeIds.size()]));
        }
        return sameNodesMap;
    }

    public static Iterable<Node> findSameNodes(GraphDatabaseService database, Node node) {
        Iterator labels = node.getLabels().iterator();
        if (labels.hasNext()) {
            return GraphTestUtils.findSameNodesByLabel(database, node, (Label)labels.next());
        }
        return GraphTestUtils.findSameNodesWithoutLabel(database, node);
    }

    public static Iterable<Node> findSameNodesWithoutLabel(GraphDatabaseService database, Node node) {
        HashSet<Node> result = new HashSet<Node>();
        for (Node candidate : GraphTestUtils.allNodes(database)) {
            if (!GraphTestUtils.areSame(node, candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public static Iterable<Node> nodesWithLabel(GraphDatabaseService database, Label label) {
        HashSet<Node> result = new HashSet<Node>();
        for (Node node : GraphTestUtils.allNodes(database)) {
            if (!node.hasLabel(label)) continue;
            result.add(node);
        }
        return result;
    }

    public static Iterable<Node> findSameNodesByLabel(GraphDatabaseService database, Node node, Label label) {
        HashSet<Node> result = new HashSet<Node>();
        for (Node candidate : GraphTestUtils.nodesWithLabel(database, label)) {
            if (!GraphTestUtils.areSame(node, candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    private static void assertRelationshipsMappingExistsForSingleNodeMapping(GraphDatabaseService database, GraphDatabaseService otherDatabase, Map<Long, Long> mapping, String firstDatabaseName) {
        HashSet<Long> usedRelationships = new HashSet<Long>();
        for (Relationship relationship : GraphTestUtils.allRelationships(otherDatabase)) {
            if (GraphTestUtils.relationshipMappingExists(database, relationship, mapping, usedRelationships)) continue;
            Assert.fail((String)("No corresponding relationship found to " + GraphTestUtils.print(relationship) + " in " + firstDatabaseName));
        }
    }

    private static boolean relationshipsMappingExists(GraphDatabaseService database, GraphDatabaseService otherDatabase, Map<Long, Long> mapping) {
        HashSet<Long> usedRelationships = new HashSet<Long>();
        for (Relationship relationship : GraphTestUtils.allRelationships(otherDatabase)) {
            if (GraphTestUtils.relationshipMappingExists(database, relationship, mapping, usedRelationships)) continue;
            return false;
        }
        return true;
    }

    private static boolean relationshipMappingExists(GraphDatabaseService database, Relationship relationship, Map<Long, Long> nodeMapping, Set<Long> usedRelationships) {
        for (Relationship candidate : database.getNodeById(nodeMapping.get(relationship.getStartNode().getId()).longValue()).getRelationships(Direction.OUTGOING)) {
            if (!nodeMapping.get(relationship.getEndNode().getId()).equals(candidate.getEndNode().getId()) || !GraphTestUtils.areSame(candidate, relationship) || usedRelationships.contains(candidate.getId())) continue;
            usedRelationships.add(candidate.getId());
            return true;
        }
        return false;
    }

    public static boolean areSame(Node node1, Node node2) {
        return GraphTestUtils.haveSameLabels(node1, node2) && GraphTestUtils.haveSameProperties((PropertyContainer)node1, (PropertyContainer)node2);
    }

    public static boolean areSame(Relationship relationship1, Relationship relationship2) {
        return GraphTestUtils.haveSameType(relationship1, relationship2) && GraphTestUtils.haveSameProperties((PropertyContainer)relationship1, (PropertyContainer)relationship2);
    }

    public static boolean haveSameLabels(Node node1, Node node2) {
        if (Iterables.count((Iterable)node1.getLabels()) != Iterables.count((Iterable)node2.getLabels())) {
            return false;
        }
        for (Label label : node1.getLabels()) {
            if (node2.hasLabel(label)) continue;
            return false;
        }
        return true;
    }

    public static boolean haveSameType(Relationship relationship1, Relationship relationship2) {
        return relationship1.isType(relationship2.getType());
    }

    public static boolean haveSameProperties(PropertyContainer pc1, PropertyContainer pc2) {
        int pc1KeyCount = 0;
        int pc2KeyCount = 0;
        for (String key : pc1.getPropertyKeys()) {
            ++pc1KeyCount;
            if (!pc2.hasProperty(key)) {
                return false;
            }
            if (GraphTestUtils.stringRepresentationsMatch(pc1.getProperty(key), pc2.getProperty(key))) continue;
            return false;
        }
        Iterator it = pc2.getPropertyKeys().iterator();
        while (it.hasNext()) {
            ++pc2KeyCount;
            it.next();
        }
        return pc1KeyCount == pc2KeyCount;
    }

    private static String print(Node node) {
        StringBuilder string = new StringBuilder("(");
        LinkedList<String> labelNames = new LinkedList<String>();
        for (Label label : node.getLabels()) {
            labelNames.add(label.name());
        }
        Collections.sort(labelNames);
        for (String labelName : labelNames) {
            string.append(":").append(labelName);
        }
        String props = GraphTestUtils.propertiesToString((PropertyContainer)node);
        if (StringUtils.isNotEmpty((String)props) && !labelNames.isEmpty()) {
            string.append(" ");
        }
        string.append(props);
        string.append(")");
        return string.toString();
    }

    private static String print(Relationship relationship) {
        StringBuilder string = new StringBuilder();
        string.append(GraphTestUtils.print(relationship.getStartNode()));
        string.append("-[:").append(relationship.getType().name());
        String props = GraphTestUtils.propertiesToString((PropertyContainer)relationship);
        if (StringUtils.isNotEmpty((String)props)) {
            string.append(" ");
        }
        string.append(props);
        string.append("]->");
        string.append(GraphTestUtils.print(relationship.getEndNode()));
        return string.toString();
    }

    private static String propertiesToString(PropertyContainer propertyContainer) {
        if (!propertyContainer.getPropertyKeys().iterator().hasNext()) {
            return "";
        }
        StringBuilder string = new StringBuilder("{");
        LinkedList<String> propertyKeys = new LinkedList<String>();
        for (String key : propertyContainer.getPropertyKeys()) {
            propertyKeys.add(key);
        }
        Collections.sort(propertyKeys);
        for (String key : propertyKeys) {
            string.append(key).append(": ").append(GraphTestUtils.propertyValueToString(propertyContainer.getProperty(key))).append(", ");
        }
        string.setLength(string.length() - 2);
        string.append("}");
        return string.toString();
    }

    private static boolean stringRepresentationsMatch(Object one, Object other) {
        String oneString = GraphTestUtils.propertyValueToString(one);
        String otherString = GraphTestUtils.propertyValueToString(other);
        return oneString.equals(otherString);
    }

    private static String propertyValueToString(Object o) {
        if (o instanceof byte[]) {
            return Arrays.toString((byte[])o);
        }
        if (o instanceof char[]) {
            return Arrays.toString((char[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.toString((boolean[])o);
        }
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof short[]) {
            return Arrays.toString((short[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof String[]) {
            return Arrays.toString((String[])o);
        }
        return String.valueOf(o);
    }
}

