/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.testutil;

import java.io.File;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.drivers.http.driver.HttpDriver;
import org.neo4j.ogm.service.Components;
import org.neo4j.ogm.testutil.FileUtils;
import org.neo4j.ogm.testutil.TestServer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDriverTestClass {
    private static final Logger logger = LoggerFactory.getLogger(MultiDriverTestClass.class);
    private static TestServer testServer;
    private static GraphDatabaseService impermanentDb;
    private static File graphStore;

    @BeforeClass
    public static synchronized void setupMultiDriverTestEnvironment() {
        Driver driver = Components.driver();
        if (driver instanceof HttpDriver) {
            testServer = Components.neo4jVersion() < 2.2 ? new TestServer.Builder().enableAuthentication(false).enableBolt(false).transactionTimeoutSeconds(30).build() : new TestServer.Builder().enableAuthentication(true).enableBolt(false).transactionTimeoutSeconds(30).build();
        } else if (driver instanceof BoltDriver) {
            testServer = new TestServer.Builder().enableBolt(true).transactionTimeoutSeconds(30).build();
        } else {
            graphStore = FileUtils.createTemporaryGraphStore();
            impermanentDb = new TestGraphDatabaseFactory().newImpermanentDatabase(graphStore);
            logger.info("Creating new impermanent database {}", (Object)impermanentDb);
            Components.setDriver((Driver)new EmbeddedDriver(impermanentDb));
        }
    }

    @AfterClass
    public static synchronized void tearDownMultiDriverTestEnvironment() {
        MultiDriverTestClass.close();
    }

    private static void close() {
        if (testServer != null) {
            if (testServer.isRunning(1000L)) {
                testServer.shutdown();
            }
            testServer = null;
        }
        if (impermanentDb != null) {
            if (impermanentDb.isAvailable(1000L)) {
                impermanentDb.shutdown();
            }
            impermanentDb = null;
            graphStore = null;
        }
    }

    public static synchronized GraphDatabaseService getGraphDatabaseService() {
        if (testServer != null) {
            return testServer.getGraphDatabaseService();
        }
        return impermanentDb;
    }
}

