/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.testutil;

import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.service.Components;
import org.neo4j.ogm.testutil.TestUtils;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.database.Database;

public class TestServer {
    private final Integer port;
    private final Integer transactionTimeoutSeconds;
    private final Boolean enableAuthentication;
    private final Boolean enableBolt;
    private GraphDatabaseService database;
    private ServerControls controls;

    private TestServer(Builder builder) {
        this.port = builder.port == null ? TestUtils.getAvailablePort() : builder.port;
        this.transactionTimeoutSeconds = builder.transactionTimeoutSeconds;
        this.enableAuthentication = builder.enableAuthentication;
        this.enableBolt = builder.enableBolt;
        this.startServer();
        System.out.println("******************************************************************************");
        System.out.println("* Starting new in memory test server on: " + this.url());
        System.out.println("******************************************************************************");
    }

    private void startServer() {
        try {
            this.controls = this.enableBolt != false ? TestServerBuilders.newInProcessBuilder().withConfig("dbms.connector.0.enabled", String.valueOf(this.enableBolt)).withConfig("dbms.connector.0.address", "localhost:" + String.valueOf(this.port)).newServer() : TestServerBuilders.newInProcessBuilder().withConfig("dbms.connector.1.enabled", "true").withConfig("dbms.connector.1.address", "localhost:" + String.valueOf(this.port)).withConfig("dbms.security.auth_enabled", String.valueOf(this.enableAuthentication)).withConfig("org.neo4j.server.webserver.port", String.valueOf(this.port)).withConfig("org.neo4j.server.transaction.timeout", String.valueOf(this.transactionTimeoutSeconds)).withConfig("dbms.transaction_timeout", String.valueOf(this.transactionTimeoutSeconds)).withConfig("dbms.security.auth_store.location", this.createAuthStore()).withConfig("unsupported.dbms.security.auth_store.location", this.createAuthStore()).withConfig("remote_shell_enabled", "false").newServer();
            this.initialise(this.controls);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    TestServer.this.shutdown();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting in-process server", e);
        }
    }

    private String createAuthStore() {
        try {
            Path authStore = Files.createTempFile("neo4j", "credentials", new FileAttribute[0]);
            authStore.toFile().deleteOnExit();
            if (this.enableAuthentication.booleanValue()) {
                try (FileWriter authStoreWriter = new FileWriter(authStore.toFile());){
                    IOUtils.write((String)"neo4j:SHA-256,03C9C54BF6EEF1FF3DFEB75403401AA0EBA97860CAC187D6452A1FCF4C63353A,819BDB957119F8DFFF65604C92980A91:", (Writer)authStoreWriter);
                }
                this.driver().getConfiguration().setCredentials("neo4j", "password");
            }
            return authStore.toAbsolutePath().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initialise(ServerControls controls) throws Exception {
        this.setDatabase(controls);
        this.driver().getConfiguration().setURI(this.url());
        this.driver().configure(this.driver().getConfiguration());
    }

    private void setDatabase(ServerControls controls) throws Exception {
        try {
            Method method = controls.getClass().getMethod("graph", new Class[0]);
            this.database = (GraphDatabaseService)method.invoke((Object)controls, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            Class<?> clazz = Class.forName("org.neo4j.harness.internal.InProcessServerControls");
            Field field = clazz.getDeclaredField("server");
            field.setAccessible(true);
            AbstractNeoServer server = (AbstractNeoServer)field.get(controls);
            Database db = server.getDatabase();
            this.database = db.getGraph();
        }
    }

    public Driver driver() {
        return Components.driver();
    }

    public synchronized void shutdown() {
        if (this.database != null && this.database.isAvailable(100L)) {
            System.out.println("******************************************************************************");
            System.out.println("* Stopping in memory test server on: " + this.url());
            System.out.println("******************************************************************************");
            this.database.shutdown();
            this.database = null;
        }
        this.controls.close();
    }

    public boolean isRunning(long timeout) {
        return this.database.isAvailable(timeout);
    }

    public String url() {
        try {
            Method method = this.enableBolt != false ? this.controls.getClass().getMethod("boltURI", new Class[0]) : this.controls.getClass().getMethod("httpURI", new Class[0]);
            Object url = method.invoke((Object)this.controls, new Object[0]);
            return url.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadClasspathCypherScriptFile(String cqlFileName) {
        this.database.execute(TestUtils.readCQLFile(cqlFileName).toString());
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.database;
    }

    public static class Builder {
        private Integer port = null;
        private Integer transactionTimeoutSeconds = 60;
        private boolean enableAuthentication = false;
        private boolean enableBolt = false;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder transactionTimeoutSeconds(int transactionTimeoutSeconds) {
            this.transactionTimeoutSeconds = transactionTimeoutSeconds;
            return this;
        }

        public Builder enableAuthentication(boolean enableAuthentication) {
            this.enableAuthentication = enableAuthentication;
            return this;
        }

        public Builder enableBolt(boolean enableBolt) {
            this.enableBolt = enableBolt;
            return this;
        }

        public TestServer build() {
            return new TestServer(this);
        }
    }
}

