/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.security.AuthenticationCommandSection;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommand;
import org.neo4j.commandline.arguments.Arguments;

public class SetDefaultAdminCommandProvider
extends AdminCommand.Provider {
    public SetDefaultAdminCommandProvider() {
        super("set-default-admin", new String[0]);
    }

    @Nonnull
    public Arguments allArguments() {
        return SetDefaultAdminCommand.arguments();
    }

    @Nonnull
    public String description() {
        return "Sets the user to become admin if users but no roles are present, for example when upgrading to neo4j 3.1 enterprise.";
    }

    @Nonnull
    public String summary() {
        return "Sets the default admin user when no roles are present.";
    }

    @Nonnull
    public AdminCommandSection commandSection() {
        return AuthenticationCommandSection.instance();
    }

    @Nonnull
    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new SetDefaultAdminCommand(homeDir, configDir, outsideWorld);
    }
}

