/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public final class MemoryManager {
    private static final long GRAB_SIZE = Integer.getInteger(MemoryManager.class.getName() + ".GRAB_SIZE", 524288).intValue();
    private long memoryReserve;
    private final long alignment;
    private Slab slabs;

    public MemoryManager(long expectedMaxMemory, long alignment) {
        this.memoryReserve = expectedMaxMemory;
        this.alignment = alignment;
    }

    public synchronized long allocateAligned(long bytes) {
        if (this.slabs == null || !this.slabs.canAllocate(bytes)) {
            long slabGrab = Math.min(GRAB_SIZE, this.memoryReserve);
            if (slabGrab < bytes) {
                slabGrab = bytes;
                Slab slab = new Slab(this.slabs, slabGrab, this.alignment);
                if (slab.canAllocate(bytes)) {
                    this.memoryReserve -= slabGrab;
                    this.slabs = slab;
                    return this.slabs.allocate(bytes);
                }
                slab.free();
                slabGrab = bytes + this.alignment;
            }
            this.memoryReserve -= slabGrab;
            this.slabs = new Slab(this.slabs, slabGrab, this.alignment);
        }
        return this.slabs.allocate(bytes);
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        Slab current = this.slabs;
        while (current != null) {
            current.free();
            current = current.next;
        }
    }

    private static class Slab {
        public final Slab next;
        private final long address;
        private final long limit;
        private final long alignMask;
        private long nextAlignedPointer;

        public Slab(Slab next, long size, long alignment) {
            this.next = next;
            this.address = UnsafeUtil.allocateMemory(size);
            this.limit = this.address + size;
            this.alignMask = alignment - 1L;
            this.nextAlignedPointer = this.nextAligned(this.address);
        }

        private long nextAligned(long pointer) {
            if ((pointer & (this.alignMask ^ 0xFFFFFFFFFFFFFFFFL)) == pointer) {
                return pointer;
            }
            return pointer + this.alignMask & (this.alignMask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public long allocate(long bytes) {
            long allocation = this.nextAlignedPointer;
            this.nextAlignedPointer = this.nextAligned(this.nextAlignedPointer + bytes);
            return allocation;
        }

        public void free() {
            UnsafeUtil.free(this.address);
        }

        public boolean canAllocate(long bytes) {
            return this.nextAlignedPointer + bytes <= this.limit;
        }
    }
}

