/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.neo4j.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.internal.Extensions;
import org.neo4j.harness.internal.Fixtures;
import org.neo4j.harness.internal.InProcessServerControls;
import org.neo4j.harness.internal.Ports;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.Digests;

public abstract class AbstractInProcessServerBuilder
implements TestServerBuilder {
    private final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
    private File serverFolder;
    private final Extensions extensions = new Extensions();
    private final Fixtures fixtures = new Fixtures();
    private final Map<String, String> config = new HashMap<String, String>();

    public AbstractInProcessServerBuilder(File workingDir) {
        File storeDir = new File(workingDir, this.randomFolderName()).getAbsoluteFile();
        this.init(storeDir);
    }

    private void init(File workingDir) {
        this.setDirectory(workingDir);
        this.withConfig(ServerSettings.auth_enabled, "false");
        this.withConfig(GraphDatabaseSettings.pagecache_memory, "8m");
        this.withConfig(Configurator.WEBSERVER_PORT_PROPERTY_KEY, Integer.toString(this.freePort()));
    }

    @Override
    public TestServerBuilder copyFrom(File originalStoreDir) {
        try {
            FileUtils.copyDirectory((File)originalStoreDir, (File)this.serverFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public ServerControls newServer() {
        OutputStream logOutputStream;
        try {
            logOutputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)this.fileSystem, (File)new File(this.serverFolder, "neo4j.log"), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create log file", e);
        }
        this.config.put(ServerSettings.third_party_packages.name(), ConfigurationBuilder.ConfiguratorWrappingConfigurationBuilder.toStringForThirdPartyPackageProperty(this.extensions.toList()));
        FormattedLogProvider userLogProvider = FormattedLogProvider.toOutputStream((OutputStream)logOutputStream);
        GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)userLogProvider);
        AbstractNeoServer neoServer = this.createNeoServer(this.config, (GraphDatabaseFacadeFactory.Dependencies)dependencies, userLogProvider);
        InProcessServerControls controls = new InProcessServerControls(this.serverFolder, neoServer, logOutputStream);
        controls.start();
        try {
            this.fixtures.applyTo(controls);
        }
        catch (RuntimeException e) {
            controls.close();
            throw e;
        }
        return controls;
    }

    protected abstract AbstractNeoServer createNeoServer(Map<String, String> var1, GraphDatabaseFacadeFactory.Dependencies var2, FormattedLogProvider var3);

    @Override
    public TestServerBuilder withConfig(Setting<?> key, String value) {
        return this.withConfig(key.name(), value);
    }

    @Override
    public TestServerBuilder withConfig(String key, String value) {
        this.config.put(key, value);
        return this;
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, Class<?> extension) {
        return this.withExtension(mountPath, extension.getPackage().getName());
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, String packageName) {
        this.extensions.add(mountPath, packageName);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(File cypherFileOrDirectory) {
        this.fixtures.add(cypherFileOrDirectory);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(String fixtureStatement) {
        this.fixtures.add(fixtureStatement);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.fixtures.add(fixtureFunction);
        return this;
    }

    private TestServerBuilder setDirectory(File dir) {
        this.serverFolder = dir;
        this.config.put(Configurator.DATABASE_LOCATION_PROPERTY_KEY, this.serverFolder.getAbsolutePath());
        return this;
    }

    private String randomFolderName() {
        return Digests.md5Hex((String)Long.toString(new Random().nextLong()));
    }

    private int freePort() {
        try {
            return Ports.findFreePort("localhost", new int[]{7474, 10000}).getPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find an available port: " + e.getMessage(), e);
        }
    }
}

