/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.SparqlSession;
import org.openrdf.http.client.query.AbstractHTTPQuery;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepositoryConnection;

public class HTTPBooleanQuery
extends AbstractHTTPQuery
implements BooleanQuery {
    private final HTTPRepositoryConnection conn;

    public HTTPBooleanQuery(HTTPRepositoryConnection conn, QueryLanguage ql, String queryString, String baseURI) {
        super((SparqlSession)conn.getSesameSession(), ql, queryString, baseURI);
        this.conn = conn;
    }

    public boolean evaluate() throws QueryEvaluationException {
        SparqlSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            return client.sendBooleanQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }
}

