/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.SparqlSession;
import org.openrdf.http.client.query.AbstractHTTPQuery;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class HTTPGraphQuery
extends AbstractHTTPQuery
implements GraphQuery {
    private final HTTPRepositoryConnection conn;

    public HTTPGraphQuery(HTTPRepositoryConnection conn, QueryLanguage ql, String queryString, String baseURI) {
        super((SparqlSession)conn.getSesameSession(), ql, queryString, baseURI);
        this.conn = conn;
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        SparqlSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            return client.sendGraphQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        SparqlSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            client.sendGraphQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.getMaxExecutionTime(), handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }
}

